/*
 * Decompiled with CFR 0.152.
 */
package com.relevantcodes.extentreports.model;

import com.relevantcodes.extentreports.LogStatus;
import com.relevantcodes.extentreports.model.Log;
import com.relevantcodes.extentreports.model.ScreenCapture;
import com.relevantcodes.extentreports.model.Screencast;
import com.relevantcodes.extentreports.model.TestAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;

public class Test {
    public ArrayList<TestAttribute> categoryList;
    public ArrayList<TestAttribute> authorList;
    public ArrayList<Log> log;
    public ArrayList<ScreenCapture> screenCapture;
    public ArrayList<Screencast> screencast;
    public ArrayList<Test> nodeList;
    public boolean isChildNode = false;
    public boolean hasEnded = false;
    public boolean hasChildNodes = false;
    public Date startedTime;
    public Date endedTime;
    public LogStatus status;
    public String description;
    public String internalWarning = "";
    public String name;
    public String statusMessage;
    public UUID id = UUID.randomUUID();

    public void prepareFinalize() {
        this.updateTestStatusRecursively(this);
        if (this.status == LogStatus.INFO) {
            this.status = LogStatus.PASS;
        }
    }

    public void trackLastRunStatus() {
        for (Log l : this.log) {
            this.findStatus(l.logStatus);
        }
        if (this.status == LogStatus.INFO) {
            this.status = LogStatus.PASS;
        }
    }

    private void updateTestStatusRecursively(Test test) {
        for (Log log : test.log) {
            this.findStatus(log.logStatus);
        }
        if (test.hasChildNodes) {
            for (Test node : test.nodeList) {
                this.updateTestStatusRecursively(node);
            }
        }
    }

    private void findStatus(LogStatus logStatus) {
        if (this.status == LogStatus.FATAL) {
            return;
        }
        if (logStatus == LogStatus.FATAL) {
            this.status = logStatus;
            return;
        }
        if (this.status == LogStatus.FAIL) {
            return;
        }
        if (logStatus == LogStatus.FAIL) {
            this.status = logStatus;
            return;
        }
        if (this.status == LogStatus.ERROR) {
            return;
        }
        if (logStatus == LogStatus.ERROR) {
            this.status = logStatus;
            return;
        }
        if (this.status == LogStatus.WARNING) {
            return;
        }
        if (logStatus == LogStatus.WARNING) {
            this.status = logStatus;
            return;
        }
        if (this.status == LogStatus.PASS) {
            return;
        }
        if (logStatus == LogStatus.PASS) {
            this.status = LogStatus.PASS;
            return;
        }
        if (this.status == LogStatus.SKIP) {
            return;
        }
        if (logStatus == LogStatus.SKIP) {
            this.status = LogStatus.SKIP;
            return;
        }
        if (this.status == LogStatus.INFO) {
            return;
        }
        if (logStatus == LogStatus.INFO) {
            this.status = LogStatus.INFO;
            return;
        }
        this.status = LogStatus.UNKNOWN;
    }

    public Test() {
        this.log = new ArrayList();
        this.categoryList = new ArrayList();
        this.authorList = new ArrayList();
        this.screenCapture = new ArrayList();
        this.screencast = new ArrayList();
        this.nodeList = new ArrayList();
    }
}

