/*
 * Decompiled with CFR 0.152.
 */
package com.relevantcodes.extentreports;

import com.relevantcodes.extentreports.DisplayOrder;
import com.relevantcodes.extentreports.ExtentTest;
import com.relevantcodes.extentreports.NetworkMode;
import com.relevantcodes.extentreports.ReportInstance;
import com.relevantcodes.extentreports.SystemInfo;
import com.relevantcodes.extentreports.model.Test;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtentReports {
    private ReportInstance reportInstance = new ReportInstance();
    private SystemInfo systemInfo;
    private ReportInstance.ReportConfig reportConfig = new ReportInstance.ReportConfig(this.reportInstance);
    private List<ExtentTest> testList;

    public ExtentReports(String filePath, Boolean replaceExisting, DisplayOrder displayOrder, NetworkMode networkMode) {
        this.reportInstance.initialize(filePath, replaceExisting, displayOrder, networkMode);
        this.systemInfo = new SystemInfo();
    }

    public ExtentReports(String filePath, Boolean replaceExisting, DisplayOrder displayOrder) {
        this(filePath, replaceExisting, DisplayOrder.OLDEST_FIRST, NetworkMode.ONLINE);
    }

    public ExtentReports(String filePath, Boolean replaceExisting, NetworkMode networkMode) {
        this(filePath, replaceExisting, DisplayOrder.OLDEST_FIRST, networkMode);
    }

    public ExtentReports(String filePath, NetworkMode networkMode) {
        this(filePath, true, DisplayOrder.OLDEST_FIRST, networkMode);
    }

    public ExtentReports(String filePath, Boolean replaceExisting) {
        this(filePath, replaceExisting, DisplayOrder.OLDEST_FIRST, NetworkMode.ONLINE);
    }

    public ExtentReports(String filePath) {
        this(filePath, true, DisplayOrder.OLDEST_FIRST, NetworkMode.ONLINE);
    }

    public synchronized ExtentTest startTest(String testName) {
        return this.startTest(testName, "");
    }

    public synchronized ExtentTest startTest(String testName, String description) {
        if (this.testList == null) {
            this.testList = new ArrayList<ExtentTest>();
        }
        ExtentTest test = new ExtentTest(testName, description);
        this.testList.add(test);
        return test;
    }

    public synchronized void endTest(ExtentTest test) {
        test.getTest().hasEnded = true;
        this.reportInstance.addTest(test.getTest());
    }

    public ReportInstance.ReportConfig config() {
        return this.reportConfig;
    }

    public ExtentReports addSystemInfo(Map<String, String> info) {
        this.systemInfo.setInfo(info);
        return this;
    }

    public ExtentReports addSystemInfo(String param, String value) {
        this.systemInfo.setInfo(param, value);
        return this;
    }

    public synchronized void flush() {
        this.removeChildTests();
        this.reportInstance.writeAllResources(this.testList, this.systemInfo);
        this.systemInfo.clear();
    }

    public synchronized void close() {
        this.removeChildTests();
        this.reportInstance.terminate(this.testList);
        if (this.testList != null) {
            this.testList.clear();
        }
    }

    private synchronized void removeChildTests() {
        if (this.testList == null) {
            return;
        }
        Iterator<ExtentTest> iterator = this.testList.iterator();
        while (iterator.hasNext()) {
            Test t = iterator.next().getTest();
            if (!t.hasChildNodes) continue;
            iterator.remove();
        }
    }
}

