/*
 * Decompiled with CFR 0.152.
 */
package com.relevantcodes.extentreports;

import com.relevantcodes.extentreports.LogStatus;
import com.relevantcodes.extentreports.model.Category;
import com.relevantcodes.extentreports.model.Log;
import com.relevantcodes.extentreports.model.ScreenCapture;
import com.relevantcodes.extentreports.model.Screencast;
import com.relevantcodes.extentreports.model.Test;
import com.relevantcodes.extentreports.model.TestAttribute;
import com.relevantcodes.extentreports.source.ImageHtml;
import com.relevantcodes.extentreports.source.ScreencastHtml;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;

public class ExtentTest {
    private LogStatus runStatus = LogStatus.UNKNOWN;
    private Test test = new Test();

    public ExtentTest(String testName, String description) {
        this.test.name = testName == null ? "" : testName.trim();
        this.test.description = description.trim();
        this.test.startedTime = Calendar.getInstance().getTime();
    }

    public void log(LogStatus logStatus, String stepName, String details) {
        Log evt = new Log();
        evt.logStatus = logStatus;
        evt.stepName = stepName == null ? "" : stepName.trim();
        evt.details = details == null ? "" : details.trim();
        evt.timestamp = Calendar.getInstance().getTime();
        this.test.log.add(evt);
        this.test.trackLastRunStatus();
        this.runStatus = this.test.status;
    }

    public void log(LogStatus logStatus, String details) {
        this.log(logStatus, "", details);
    }

    public String addScreenCapture(String imgPath) {
        String screenCaptureHtml = this.isPathRelative(imgPath) != false ? ImageHtml.getSource(imgPath).replace("file:///", "") : ImageHtml.getSource(imgPath);
        ScreenCapture img = new ScreenCapture();
        img.src = screenCaptureHtml;
        img.testName = this.test.name;
        this.test.screenCapture.add(img);
        return screenCaptureHtml;
    }

    public String addScreencast(String screencastPath) {
        String screencastHtml = this.isPathRelative(screencastPath) != false ? ScreencastHtml.getSource(screencastPath).replace("file:///", "") : ScreencastHtml.getSource(screencastPath);
        Screencast sc = new Screencast();
        sc.src = screencastHtml;
        sc.testName = this.test.name;
        this.test.screencast.add(sc);
        return screencastHtml;
    }

    public ExtentTest assignCategory(String ... category) {
        ArrayList<String> list = new ArrayList<String>();
        for (String c : category) {
            if (!list.contains(c)) {
                this.test.categoryList.add(new Category(c));
            }
            list.add(c);
        }
        return this;
    }

    public ExtentTest appendChild(ExtentTest node) {
        node.getTest().endedTime = Calendar.getInstance().getTime();
        node.getTest().isChildNode = true;
        node.getTest().trackLastRunStatus();
        this.test.hasChildNodes = true;
        ArrayList<String> list = new ArrayList<String>();
        for (TestAttribute attr : this.test.categoryList) {
            if (list.contains(attr.getName())) continue;
            list.add(attr.getName());
        }
        for (TestAttribute attr : node.getTest().categoryList) {
            if (list.contains(attr.getName())) continue;
            this.test.categoryList.add(attr);
        }
        this.test.nodeList.add(node.getTest());
        return this;
    }

    public LogStatus getRunStatus() {
        return this.runStatus;
    }

    public Test getTest() {
        return this.test;
    }

    private Boolean isPathRelative(String path) {
        if (path.indexOf("http") == 0 || !new File(path).isAbsolute()) {
            return true;
        }
        return false;
    }
}

