/*
 * Decompiled with CFR 0.152.
 */
package com.relevantcodes.extentreports;

import com.relevantcodes.extentreports.LogSettings;
import com.relevantcodes.extentreports.LogStatus;
import com.relevantcodes.extentreports.SourceBuilder;
import com.relevantcodes.extentreports.model.Test;
import com.relevantcodes.extentreports.model.TestAttribute;
import com.relevantcodes.extentreports.source.ExtentFlag;
import com.relevantcodes.extentreports.source.Icon;
import com.relevantcodes.extentreports.source.StepHtml;
import com.relevantcodes.extentreports.source.TestHtml;
import com.relevantcodes.extentreports.support.DateTimeHelper;

class TestBuilder {
    TestBuilder() {
    }

    public static String getSource(Test test) {
        if (test.isChildNode) {
            return "";
        }
        String testSource = TestHtml.getSource(3);
        if (test.log.size() > 0 && test.log.get((int)0).stepName != "") {
            testSource = TestHtml.getSource(4);
        }
        if (test.description == null || test.description == "") {
            testSource = testSource.replace(ExtentFlag.getPlaceHolder("descVis"), "style='display:none;'");
        }
        long diff = test.endedTime.getTime() - test.startedTime.getTime();
        long hours = diff / 3600000L % 24L;
        long mins = diff / 60000L % 60L;
        long secs = diff / 1000L % 60L;
        String[] testFlags = new String[]{ExtentFlag.getPlaceHolder("testName"), ExtentFlag.getPlaceHolder("testStatus"), ExtentFlag.getPlaceHolder("testStartTime"), ExtentFlag.getPlaceHolder("testEndTime"), ExtentFlag.getPlaceHolder("testTimeTaken"), ExtentFlag.getPlaceHolder("testDescription"), ExtentFlag.getPlaceHolder("descVis"), ExtentFlag.getPlaceHolder("category"), ExtentFlag.getPlaceHolder("testWarnings")};
        String[] testValues = new String[]{test.name, test.status.toString().toLowerCase(), DateTimeHelper.getFormattedDateTime(test.startedTime, LogSettings.logDateTimeFormat), DateTimeHelper.getFormattedDateTime(test.endedTime, LogSettings.logDateTimeFormat), hours + "h " + mins + "m " + secs + "s", test.description, "", "", TestHtml.getWarningSource(test.internalWarning)};
        testSource = SourceBuilder.build(testSource, testFlags, testValues);
        testFlags = new String[]{ExtentFlag.getPlaceHolder("testCategory"), ExtentFlag.getPlaceHolder("category")};
        for (TestAttribute attr : test.categoryList) {
            testValues = new String[]{TestHtml.getCategorySource() + ExtentFlag.getPlaceHolder("testCategory"), attr.getName()};
            testSource = SourceBuilder.build(testSource, testFlags, testValues);
        }
        String stepSrc = StepHtml.getSource(2);
        String[] stepFlags = new String[]{ExtentFlag.getPlaceHolder("step"), ExtentFlag.getPlaceHolder("timeStamp"), ExtentFlag.getPlaceHolder("stepStatusU"), ExtentFlag.getPlaceHolder("stepStatus"), ExtentFlag.getPlaceHolder("statusIcon"), ExtentFlag.getPlaceHolder("stepName"), ExtentFlag.getPlaceHolder("details")};
        if (test.log.size() > 0) {
            if (test.log.get((int)0).stepName != "") {
                stepSrc = StepHtml.getSource(0);
            }
            for (int ix = 0; ix < test.log.size(); ++ix) {
                String[] stepValues = new String[]{stepSrc + ExtentFlag.getPlaceHolder("step"), DateTimeHelper.getFormattedDateTime(test.log.get((int)ix).timestamp, LogSettings.logTimeFormat), test.log.get((int)ix).logStatus.toString().toUpperCase(), test.log.get((int)ix).logStatus.toString().toLowerCase(), Icon.getIcon(test.log.get((int)ix).logStatus), test.log.get((int)ix).stepName, test.log.get((int)ix).details};
                testSource = SourceBuilder.build(testSource, stepFlags, stepValues);
            }
        }
        testSource = testSource.replace(ExtentFlag.getPlaceHolder("step"), "");
        testSource = TestBuilder.addChildTests(test, testSource, 1);
        return testSource;
    }

    private static String addChildTests(Test test, String testSource, int nodeLevel) {
        String stepSrc = "";
        String[] testFlags = new String[]{ExtentFlag.getPlaceHolder("nodeList"), ExtentFlag.getPlaceHolder("nodeName"), ExtentFlag.getPlaceHolder("nodeStartTime"), ExtentFlag.getPlaceHolder("nodeEndTime"), ExtentFlag.getPlaceHolder("nodeTimeTaken"), ExtentFlag.getPlaceHolder("nodeLevel")};
        String[] stepFlags = new String[]{ExtentFlag.getPlaceHolder("nodeStep"), ExtentFlag.getPlaceHolder("timeStamp"), ExtentFlag.getPlaceHolder("stepStatusU"), ExtentFlag.getPlaceHolder("stepStatus"), ExtentFlag.getPlaceHolder("statusIcon"), ExtentFlag.getPlaceHolder("stepName"), ExtentFlag.getPlaceHolder("details")};
        for (Test node : test.nodeList) {
            String nodeSource = TestHtml.getNodeSource(3);
            if (node.log.size() > 0 && node.log.get((int)0).stepName != "") {
                nodeSource = TestHtml.getNodeSource(4);
            }
            long diff = node.endedTime.getTime() - node.startedTime.getTime();
            long hours = diff / 3600000L % 24L;
            long mins = diff / 60000L % 60L;
            long secs = diff / 1000L % 60L;
            String[] testValues = new String[]{nodeSource + ExtentFlag.getPlaceHolder("nodeList"), node.name, DateTimeHelper.getFormattedDateTime(node.startedTime, LogSettings.logDateTimeFormat), DateTimeHelper.getFormattedDateTime(node.endedTime, LogSettings.logDateTimeFormat), hours + "h " + mins + "m " + secs + "s", "node-" + nodeLevel + "x"};
            testSource = SourceBuilder.build(testSource, testFlags, testValues);
            if (node.log.size() > 0) {
                testSource = SourceBuilder.build(testSource, new String[]{ExtentFlag.getPlaceHolder("nodeStatus")}, new String[]{node.status.toString().toLowerCase()});
                stepSrc = StepHtml.getSource(2);
                if (node.log.get((int)0).stepName != "") {
                    stepSrc = StepHtml.getSource(0);
                }
                for (int ix = 0; ix < node.log.size(); ++ix) {
                    String[] stepValues = new String[]{stepSrc + ExtentFlag.getPlaceHolder("nodeStep"), DateTimeHelper.getFormattedDateTime(node.log.get((int)ix).timestamp, LogSettings.logTimeFormat), node.log.get((int)ix).logStatus.toString().toUpperCase(), node.log.get((int)ix).logStatus.toString().toLowerCase(), Icon.getIcon(node.log.get((int)ix).logStatus), node.log.get((int)ix).stepName, node.log.get((int)ix).details};
                    testSource = SourceBuilder.build(testSource, stepFlags, stepValues);
                }
            }
            testSource = SourceBuilder.build(testSource, new String[]{ExtentFlag.getPlaceHolder("step"), ExtentFlag.getPlaceHolder("nodeStep")}, new String[]{"", ""});
            if (!node.hasChildNodes) continue;
            testSource = TestBuilder.addChildTests(node, testSource, ++nodeLevel);
            --nodeLevel;
        }
        return testSource;
    }

    public static String getQuickTestSummary(Test test) {
        if (test.isChildNode) {
            return "";
        }
        String src = TestHtml.getSourceQuickView();
        LogCounts lc = new TestBuilder().new LogCounts().getLogCounts(test);
        String[] flags = new String[]{ExtentFlag.getPlaceHolder("testName"), ExtentFlag.getPlaceHolder("testWarnings"), ExtentFlag.getPlaceHolder("currentTestPassedCount"), ExtentFlag.getPlaceHolder("currentTestFailedCount"), ExtentFlag.getPlaceHolder("currentTestFatalCount"), ExtentFlag.getPlaceHolder("currentTestErrorCount"), ExtentFlag.getPlaceHolder("currentTestWarningCount"), ExtentFlag.getPlaceHolder("currentTestInfoCount"), ExtentFlag.getPlaceHolder("currentTestSkippedCount"), ExtentFlag.getPlaceHolder("currentTestUnknownCount"), ExtentFlag.getPlaceHolder("currentTestRunStatus"), ExtentFlag.getPlaceHolder("currentTestRunStatusU")};
        String[] values = new String[]{test.name, TestHtml.getWarningSource(test.internalWarning), String.valueOf(lc.pass), String.valueOf(lc.fail), String.valueOf(lc.fatal), String.valueOf(lc.error), String.valueOf(lc.warning), String.valueOf(lc.info), String.valueOf(lc.skip), String.valueOf(lc.unknown), test.status.toString().toLowerCase(), test.status.toString()};
        src = SourceBuilder.build(src, flags, values);
        return src;
    }

    private class LogCounts {
        public int pass = 0;
        public int fail = 0;
        public int fatal = 0;
        public int error = 0;
        public int warning = 0;
        public int info = 0;
        public int skip = 0;
        public int unknown = 0;

        public LogCounts getLogCounts(Test test) {
            for (int ix = 0; ix < test.log.size(); ++ix) {
                if (test.log.get((int)ix).logStatus == LogStatus.PASS) {
                    ++this.pass;
                    continue;
                }
                if (test.log.get((int)ix).logStatus == LogStatus.FAIL) {
                    ++this.fail;
                    continue;
                }
                if (test.log.get((int)ix).logStatus == LogStatus.FATAL) {
                    ++this.fatal;
                    continue;
                }
                if (test.log.get((int)ix).logStatus == LogStatus.ERROR) {
                    ++this.error;
                    continue;
                }
                if (test.log.get((int)ix).logStatus == LogStatus.WARNING) {
                    ++this.warning;
                    continue;
                }
                if (test.log.get((int)ix).logStatus == LogStatus.INFO) {
                    ++this.info;
                    continue;
                }
                if (test.log.get((int)ix).logStatus == LogStatus.SKIP) {
                    ++this.skip;
                    continue;
                }
                if (test.log.get((int)ix).logStatus != LogStatus.UNKNOWN) continue;
                ++this.unknown;
            }
            for (Test node : test.nodeList) {
                this.getLogCounts(node);
            }
            return this;
        }
    }
}

