/*
 * Decompiled with CFR 0.152.
 */
package com.relevantcodes.extentreports;

import com.relevantcodes.extentreports.ExtentReports;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    private Map<String, String> configurationMap;
    private InputStream stream;
    private static final Logger logger = Logger.getLogger(ExtentReports.class.getName());

    public Map<String, String> getConfigurationMap() {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        String value = null;
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(this.stream);
            doc.getDocumentElement().normalize();
            NodeList nodeList = doc.getElementsByTagName("configuration").item(0).getChildNodes();
            for (int ix = 0; ix < nodeList.getLength(); ++ix) {
                Element el;
                Node node = nodeList.item(ix);
                Element element = el = node.getNodeType() == 1 ? (Element)node : null;
                if (el == null) continue;
                value = el.getTextContent();
                if (el instanceof CharacterData) {
                    value = ((CharacterData)((Object)el)).getData();
                }
                this.configurationMap.put(el.getNodeName(), value);
            }
            return this.configurationMap;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "The configuration file or URL was not found", e);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Configuration(URL url) {
        try {
            this.stream = url.openStream();
            logger.log(Level.INFO, "Configurating report from " + url.getPath());
            this.configurationMap = new HashMap<String, String>();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Configuration(File file) {
        try {
            this.stream = new FileInputStream(file);
            logger.log(Level.INFO, "Configurating report from " + file.getPath());
            this.configurationMap = new HashMap<String, String>();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

