/*
 * Decompiled with CFR 0.152.
 */
package com.relevantcodes.extentreports;

import com.relevantcodes.extentreports.Configuration;
import com.relevantcodes.extentreports.DBReporter;
import com.relevantcodes.extentreports.DisplayOrder;
import com.relevantcodes.extentreports.ExtentTest;
import com.relevantcodes.extentreports.HTMLReporter;
import com.relevantcodes.extentreports.NetworkMode;
import com.relevantcodes.extentreports.Report;
import com.relevantcodes.extentreports.ReporterType;
import com.relevantcodes.extentreports.converters.TestConverter;
import com.relevantcodes.extentreports.model.Test;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtentReports
extends Report {
    private static final Logger logger = Logger.getLogger(ExtentReports.class.getName());
    private final String extentConfigFile = "extent-config.xml";

    public ExtentReports(String filePath, Boolean replaceExisting, DisplayOrder displayOrder, NetworkMode networkMode) {
        File file;
        this.setFilePath(filePath);
        this.setReplaceExisting(replaceExisting);
        this.setDisplayOrder(displayOrder);
        this.setNetworkMode(networkMode);
        String resourceFile = ExtentReports.class.getPackage().getName().replace(".", "/") + "/resources/" + "extent-config.xml";
        this.loadConfig(this.getClass().getClassLoader().getResource(resourceFile));
        this.attach(new HTMLReporter(filePath));
        if (!replaceExisting.booleanValue() && (file = new File(filePath)).exists()) {
            TestConverter converter = new TestConverter(this, file);
            converter.createTestList();
        }
    }

    public ExtentReports(String filePath, Boolean replaceExisting, DisplayOrder displayOrder) {
        this(filePath, replaceExisting, DisplayOrder.OLDEST_FIRST, NetworkMode.ONLINE);
    }

    public ExtentReports(String filePath, Boolean replaceExisting, NetworkMode networkMode) {
        this(filePath, replaceExisting, DisplayOrder.OLDEST_FIRST, networkMode);
    }

    public ExtentReports(String filePath, NetworkMode networkMode) {
        this(filePath, true, DisplayOrder.OLDEST_FIRST, networkMode);
    }

    public ExtentReports(String filePath, Boolean replaceExisting) {
        this(filePath, replaceExisting, DisplayOrder.OLDEST_FIRST, NetworkMode.ONLINE);
    }

    public ExtentReports(String filePath) {
        this(filePath, true, DisplayOrder.OLDEST_FIRST, NetworkMode.ONLINE);
    }

    public void loadConfig(File configFile) {
        if (!configFile.exists()) {
            logger.log(Level.WARNING, "Unable to perform report configuration. The file " + configFile.getAbsolutePath() + " was not found.");
            return;
        }
        if (!configFile.getName().endsWith(".xml")) {
            logger.log(Level.WARNING, "Unable to perform report configuration. The file " + configFile.getAbsolutePath() + " must be an XML file.");
            return;
        }
        this.loadConfig(new Configuration(configFile));
    }

    public void loadConfig(URL url) {
        this.loadConfig(new Configuration(url));
    }

    public void loadConfig(Class clazz, String fileName) {
        this.loadConfig(clazz, null, fileName);
    }

    public void loadConfig(Class clazz, String basePackagePath, String fileName) {
        URL url;
        String fullPackagePath = clazz.getPackage().getName().replace(".", File.separator) + File.separator + fileName;
        if (basePackagePath != null) {
            fullPackagePath = clazz.getPackage().getName().replace(".", File.separator) + File.separator + basePackagePath + File.separator + fileName;
        }
        if ((url = this.getClass().getClassLoader().getResource(fullPackagePath)) == null) {
            logger.log(Level.WARNING, "Unable to perform report configuration. The package or file " + fullPackagePath + " was not found.");
            return;
        }
        this.loadConfig(new Configuration(url));
    }

    public synchronized ExtentReports startReporter(ReporterType reporterType, String filePath) {
        if (reporterType == ReporterType.DB) {
            this.attach(new DBReporter(filePath));
        }
        return this;
    }

    public synchronized ExtentTest startTest(String testName) {
        return this.startTest(testName, "");
    }

    public synchronized ExtentTest startTest(String testName, String description) {
        if (this.testList == null) {
            this.testList = new ArrayList();
        }
        ExtentTest test = new ExtentTest(testName, description);
        this.testList.add(test);
        return test;
    }

    public synchronized void endTest(ExtentTest extentTest) {
        Test test = extentTest.getTest();
        test.hasEnded = true;
        this.addTest(test);
    }

    public ExtentReports addSystemInfo(Map<String, String> info) {
        this.systemInfo.setInfo(info);
        return this;
    }

    public ExtentReports addSystemInfo(String param, String value) {
        this.systemInfo.setInfo(param, value);
        return this;
    }

    public void setTestRunnerOutput(String log) {
        this.setTestRunnerLogs(log);
    }

    @Override
    public synchronized void flush() {
        this.removeChildTests();
        super.flush();
    }

    public synchronized void close() {
        this.terminate();
        if (this.testList != null) {
            this.testList.clear();
        }
    }

    @Deprecated
    public HTMLReporter.Config config() {
        HTMLReporter hr = new HTMLReporter(null);
        return new HTMLReporter.Config(hr);
    }

    private synchronized void removeChildTests() {
        if (this.testList == null) {
            return;
        }
        Iterator iterator = this.testList.iterator();
        while (iterator.hasNext()) {
            Test t = ((ExtentTest)iterator.next()).getTest();
            if (!t.isChildNode) continue;
            iterator.remove();
        }
    }
}

