/*
 * Decompiled with CFR 0.152.
 */
package com.relevantcodes.extentreports;

import com.relevantcodes.extentreports.LogStatus;
import com.relevantcodes.extentreports.model.Author;
import com.relevantcodes.extentreports.model.Category;
import com.relevantcodes.extentreports.model.Log;
import com.relevantcodes.extentreports.model.ScreenCapture;
import com.relevantcodes.extentreports.model.Screencast;
import com.relevantcodes.extentreports.model.Test;
import com.relevantcodes.extentreports.model.TestAttribute;
import com.relevantcodes.extentreports.utils.ExceptionUtil;
import com.relevantcodes.extentreports.view.ScreencastHtml;
import com.relevantcodes.extentreports.view.ScreenshotHtml;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;

public class ExtentTest {
    private LogStatus runStatus = LogStatus.UNKNOWN;
    private Test test = new Test();

    public ExtentTest(String testName, String description) {
        this.test.setName(testName == null ? "" : testName.trim());
        this.test.setDescription(description.trim());
    }

    public void log(LogStatus logStatus, String stepName, String details) {
        Log evt = new Log();
        evt.setLogStatus(logStatus);
        evt.setStepName(stepName == null ? null : stepName.trim());
        evt.setDetails(details == null ? "" : details.trim());
        this.test.setLog(evt);
        this.test.trackLastRunStatus();
        this.runStatus = this.test.getStatus();
    }

    public void log(LogStatus logStatus, String stepName, Throwable t) {
        this.log(logStatus, stepName, "<pre>" + ExceptionUtil.getStackTrace(t) + "</pre>");
    }

    public void log(LogStatus logStatus, Throwable t) {
        this.log(logStatus, null, "<pre>" + ExceptionUtil.getStackTrace(t) + "</pre>");
    }

    public void log(LogStatus logStatus, String details) {
        this.log(logStatus, null, details);
    }

    public String addScreenCapture(String imgPath) {
        String screenCaptureHtml = this.isPathRelative(imgPath) != false ? ScreenshotHtml.getSource(imgPath).replace("file:///", "") : ScreenshotHtml.getSource(imgPath);
        ScreenCapture img = new ScreenCapture();
        img.setSource(screenCaptureHtml);
        img.setTestName(this.test.getName());
        img.setTestId(this.test.getId());
        this.test.setScreenCapture(img);
        return screenCaptureHtml;
    }

    public String addScreencast(String screencastPath) {
        String screencastHtml = this.isPathRelative(screencastPath) != false ? ScreencastHtml.getSource(screencastPath).replace("file:///", "") : ScreencastHtml.getSource(screencastPath);
        Screencast sc = new Screencast();
        sc.setSource(screencastHtml);
        sc.setTestName(this.test.getName());
        sc.setTestId(this.test.getId());
        this.test.setScreencast(sc);
        return screencastHtml;
    }

    public ExtentTest assignCategory(String ... categories) {
        ArrayList<String> list = new ArrayList<String>();
        for (String c : categories) {
            if (!c.trim().equals("") && !list.contains(c)) {
                this.test.setCategory(new Category(c));
            }
            list.add(c);
        }
        return this;
    }

    public ExtentTest assignAuthor(String ... authors) {
        ArrayList<String> list = new ArrayList<String>();
        for (String author : authors) {
            if (!author.trim().equals("") && !list.contains(author)) {
                this.test.setAuthor(new Author(author));
            }
            list.add(author);
        }
        return this;
    }

    public ExtentTest appendChild(ExtentTest node) {
        node.getTest().setEndedTime(Calendar.getInstance().getTime());
        node.getTest().isChildNode = true;
        node.getTest().trackLastRunStatus();
        this.test.hasChildNodes = true;
        ArrayList<String> list = new ArrayList<String>();
        for (TestAttribute attr : this.test.getCategoryList()) {
            if (list.contains(attr.getName())) continue;
            list.add(attr.getName());
        }
        for (TestAttribute attr : node.getTest().getCategoryList()) {
            if (list.contains(attr.getName())) continue;
            this.test.setCategory(attr);
        }
        this.test.setNode(node.getTest());
        return this;
    }

    public LogStatus getRunStatus() {
        return this.runStatus;
    }

    public Test getTest() {
        return this.test;
    }

    private Boolean isPathRelative(String path) {
        if (path.indexOf("http") == 0 || !new File(path).isAbsolute()) {
            return true;
        }
        return false;
    }
}

