/*
 * Decompiled with CFR 0.152.
 */
package com.relevantcodes.extentreports;

import com.relevantcodes.extentreports.IReporter;
import com.relevantcodes.extentreports.LogSettings;
import com.relevantcodes.extentreports.LogStatus;
import com.relevantcodes.extentreports.Report;
import com.relevantcodes.extentreports.model.Category;
import com.relevantcodes.extentreports.model.Log;
import com.relevantcodes.extentreports.model.Test;
import com.relevantcodes.extentreports.model.TestAttribute;
import java.io.File;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class DBReporter
extends LogSettings
implements IReporter {
    static final Logger logger = Logger.getLogger(LogSettings.class.getName());
    private boolean isReady = false;
    private Report report;
    private Connection connection;
    private Test test;
    private Map<String, String> systemMap;
    private final String CREATE_REPORT_TABLE = "CREATE TABLE IF NOT EXISTS Report (ReportIDExtent TEXT NOT NULL, StartMillis TIME NOT NULL, EndMillis TIME NOT NULL, ReportStatus TEXT NOT NULL)";
    private final String INSERT_REPORT = "INSERT INTO Report ( ReportIDExtent, StartMillis, EndMillis, ReportStatus )VALUES (?, ?, ?, ?)";
    private final String UPDATE_REPORT = "UPDATE Report SET EndMillis = ?, ReportStatus = ? WHERE ReportIDExtent = '%%REPORTID%%'";
    private final String CREATE_SYSTEM_INFO_TABLE = "CREATE TABLE IF NOT EXISTS SystemInfo (ReportIDExtent TEXT NOT NULL, Param TEXT NOT NULL, Value TEXT NOT NULL)";
    private final String INSERT_SYSTEM_INFO = "INSERT INTO SystemInfo ( ReportIDExtent, Param, Value)VALUES (?, ?, ?)";
    private final String CREATE_TEST_TABLE = "CREATE TABLE IF NOT EXISTS Test (ReportIDExtent TEXT NOT NULL, TestIDExtent TEXT NOT NULL, TestName TEXT NOT NULL, Status TEXT NOT NULL, Description TEXT, InternalWarning TEXT, StartMillis TIME NOT NULL, EndMillis TIME NOT NULL, StepsPass INTEGER NOT NULL, StepsFail INTEGER NOT NULL, StepsFatal INTEGER NOT NULL, StepsError INTEGER NOT NULL, StepsWarning INTEGER NOT NULL, StepsInfo INTEGER NOT NULL, StepsSkip INTEGER NOT NULL, StepsUnknown INTEGER NOT NULL, ChildNodesCount INTEGER)";
    private final String INSERT_TEST = "INSERT INTO Test ( ReportIDExtent, TestIDExtent, TestName, Status, Description, InternalWarning, StartMillis, EndMillis, StepsPass, StepsFail, StepsFatal, StepsError, StepsWarning, StepsInfo, StepsSkip, StepsUnknown, ChildNodesCount ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private final String CREATE_NODE_TABLE = "CREATE TABLE IF NOT EXISTS Node (NodeIDExtent TEXT NOT NULL, NodeName TEXT NOT NULL, NodeLevel INTEGER NOT NULL, ReportIDExtent TEXT NOT NULL, TestIDExtent TEXT NOT NULL, ParentTestName TEXT NOT NULL, Status TEXT NOT NULL, Description TEXT, StartMillis TIME NOT NULL, EndMillis TIME NOT NULL, ChildNodesCount INTEGER)";
    private final String INSERT_NODE = "INSERT INTO Node ( NodeIDExtent, NodeName, NodeLevel, ReportIDExtent, TestIDExtent, ParentTestName, Status, Description, StartMillis, EndMillis, ChildNodesCount ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private final String CREATE_LOG_TABLE = "CREATE TABLE IF NOT EXISTS Log (ReportIDExtent TEXT NOT NULL, TestIDExtent TEXT NOT NULL, TestName TEXT NOT NULL, LogID INTEGER NOT NULL, Status TEXT NOT NULL, StepName TEXT, Details TEXT, Timestamp TIME NOT NULL)";
    private final String INSERT_LOG = "INSERT INTO Log (ReportIDExtent, TestIDExtent, TestName, LogID, Status, StepName, Details, Timestamp ) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    private final String CREATE_CATEGORY_TABLE = "CREATE TABLE IF NOT EXISTS Category ( ReportIDExtent TEXT NOT NULL, TestIDExtent TEXT NOT NULL, TestName TEXT NOT NULL, CategoryName TEXT NOT NULL)";
    private final String INSERT_CATEGORY = "INSERT INTO Category ( ReportIDExtent, TestIDExtent, TestName, CategoryName ) VALUES (?, ?, ?, ?)";
    private final String DEFAULT_DB_NAME = "extent";
    private final String DEFAULT_DB_EXT = "db";
    private String filePath;

    @Override
    public void start(Report report) {
        int index;
        this.report = report;
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, "Unable to start database reporter. Extent database will not be created.", e);
            e.printStackTrace();
            return;
        }
        File dbFile = new File(this.filePath);
        if (!dbFile.exists() && !dbFile.getParentFile().exists()) {
            dbFile.getParentFile().mkdirs();
        }
        if ((index = dbFile.getName().lastIndexOf(".")) > 0 && !dbFile.getName().substring(index + 1).equals("db")) {
            this.filePath = dbFile.getParentFile().getPath() + "/" + "extent" + "." + "db";
        } else if (index == -1) {
            this.filePath = dbFile.getPath() + "/" + "extent" + "." + "db";
        }
        try {
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.filePath);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return;
        }
        this.systemMap = new HashMap<String, String>();
        this.createReportTable();
        this.createSystemInfoTable();
        this.createTestTable();
        this.createNodeTable();
        this.createLogTable();
        this.insertCurrentReportRow();
        this.isReady = true;
    }

    @Override
    public void flush() {
        if (this.connection == null) {
            return;
        }
        Map<String, String> info = this.report.getSystemInfo().getInfo();
        if (info.size() > 0) {
            for (Map.Entry<String, String> entry : info.entrySet()) {
                if (!this.systemMap.containsKey(entry.getKey())) {
                    try {
                        PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO SystemInfo ( ReportIDExtent, Param, Value)VALUES (?, ?, ?)");
                        int ix = 0;
                        stmt.setString(++ix, this.report.getId().toString());
                        stmt.setString(++ix, entry.getKey());
                        stmt.setString(++ix, entry.getValue());
                        stmt.executeUpdate();
                        stmt.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                this.systemMap.put(entry.getKey(), entry.getValue());
            }
        }
        this.updateCurrentReportRow();
    }

    @Override
    public void addTest(Test test) {
        if (!this.isReady) {
            logger.log(Level.SEVERE, "Failed to add test " + test.getName() + " to Extent database");
            return;
        }
        this.test = test;
        try {
            PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO Test ( ReportIDExtent, TestIDExtent, TestName, Status, Description, InternalWarning, StartMillis, EndMillis, StepsPass, StepsFail, StepsFatal, StepsError, StepsWarning, StepsInfo, StepsSkip, StepsUnknown, ChildNodesCount ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            int ix = 0;
            stmt.setString(++ix, this.report.getId().toString());
            stmt.setString(++ix, test.getId().toString());
            stmt.setString(++ix, test.getName());
            stmt.setString(++ix, test.getStatus().toString());
            stmt.setString(++ix, test.getDescription());
            stmt.setString(++ix, test.getInternalWarning());
            stmt.setDate(++ix, new Date(test.getStartedTime().getTime()));
            stmt.setDate(++ix, new Date(test.getEndedTime().getTime()));
            stmt.setInt(++ix, test.getLogCounts().get(LogStatus.PASS));
            stmt.setInt(++ix, test.getLogCounts().get(LogStatus.FAIL));
            stmt.setInt(++ix, test.getLogCounts().get(LogStatus.FATAL));
            stmt.setInt(++ix, test.getLogCounts().get(LogStatus.ERROR));
            stmt.setInt(++ix, test.getLogCounts().get(LogStatus.WARNING));
            stmt.setInt(++ix, test.getLogCounts().get(LogStatus.INFO));
            stmt.setInt(++ix, test.getLogCounts().get(LogStatus.SKIP));
            stmt.setInt(++ix, test.getLogCounts().get(LogStatus.UNKNOWN));
            stmt.setInt(++ix, test.getNodeList().size());
            stmt.executeUpdate();
            stmt.close();
            this.addLogs(test);
            this.addNodes(test, 0);
            if (test.getCategoryList().size() > 0) {
                this.addCategories(test);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stop() {
        if (this.connection == null) {
            return;
        }
        try {
            this.updateCurrentReportRow();
            this.connection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void insertCurrentReportRow() {
        try {
            PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO Report ( ReportIDExtent, StartMillis, EndMillis, ReportStatus )VALUES (?, ?, ?, ?)");
            int ix = 0;
            stmt.setString(++ix, this.report.getId().toString());
            stmt.setDate(++ix, new Date(this.report.getStartedTime().getTime()));
            stmt.setDate(++ix, new Date(Calendar.getInstance().getTime().getTime()));
            stmt.setString(++ix, this.report.getStatus().toString());
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void updateCurrentReportRow() {
        try {
            PreparedStatement stmt = this.connection.prepareStatement("UPDATE Report SET EndMillis = ?, ReportStatus = ? WHERE ReportIDExtent = '%%REPORTID%%'".replace("%%REPORTID%%", this.report.getId().toString()));
            int ix = 0;
            stmt.setDate(++ix, new Date(Calendar.getInstance().getTime().getTime()));
            stmt.setString(++ix, this.report.getStatus().toString());
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void addNodes(Test test, int level) {
        if (test.hasChildNodes) {
            for (Test node : test.getNodeList()) {
                this.addNode(node, ++level);
                --level;
                if (!node.hasChildNodes) continue;
                this.addNodes(node, ++level);
                --level;
            }
        }
    }

    private void addNode(Test node, int level) {
        try {
            PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO Node ( NodeIDExtent, NodeName, NodeLevel, ReportIDExtent, TestIDExtent, ParentTestName, Status, Description, StartMillis, EndMillis, ChildNodesCount ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            int ix = 0;
            stmt.setString(++ix, node.getId().toString());
            stmt.setString(++ix, node.getName());
            stmt.setInt(++ix, level);
            stmt.setString(++ix, this.report.getId().toString());
            stmt.setString(++ix, this.test.getId().toString());
            stmt.setString(++ix, this.test.getName());
            stmt.setString(++ix, node.getStatus().toString());
            stmt.setString(++ix, node.getDescription());
            stmt.setDate(++ix, new Date(node.getStartedTime().getTime()));
            stmt.setDate(++ix, new Date(node.getEndedTime().getTime()));
            stmt.setInt(++ix, node.getNodeList().size());
            stmt.executeUpdate();
            stmt.close();
            this.addLogs(node);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void addLogs(Test test) {
        try {
            PreparedStatement stmt = this.getPreparedStatement("INSERT INTO Log (ReportIDExtent, TestIDExtent, TestName, LogID, Status, StepName, Details, Timestamp ) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
            int ix = 0;
            int id = 0;
            Test.LogIterator iter = test.logIterator();
            while (iter.hasNext()) {
                Log log = (Log)iter.next();
                stmt.setString(++ix, this.report.getId().toString());
                stmt.setString(++ix, test.getId().toString());
                stmt.setString(++ix, test.getName());
                stmt.setInt(++ix, id++);
                stmt.setString(++ix, log.getLogStatus().toString());
                stmt.setString(++ix, log.getStepName());
                stmt.setString(++ix, log.getDetails());
                stmt.setDate(++ix, new Date(log.getTimestamp().getTime()));
                stmt.executeUpdate();
                ix = 0;
            }
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void addCategories(Test test) {
        this.createCategoryTable();
        try {
            PreparedStatement stmt = this.getPreparedStatement("INSERT INTO Category ( ReportIDExtent, TestIDExtent, TestName, CategoryName ) VALUES (?, ?, ?, ?)");
            for (TestAttribute c : test.getCategoryList()) {
                stmt.setString(1, this.report.getId().toString());
                stmt.setString(2, test.getId().toString());
                stmt.setString(3, test.getName());
                stmt.setString(4, ((Category)c).getName());
                stmt.executeUpdate();
            }
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void createReportTable() {
        this.updateDb("CREATE TABLE IF NOT EXISTS Report (ReportIDExtent TEXT NOT NULL, StartMillis TIME NOT NULL, EndMillis TIME NOT NULL, ReportStatus TEXT NOT NULL)");
    }

    private void createSystemInfoTable() {
        this.updateDb("CREATE TABLE IF NOT EXISTS SystemInfo (ReportIDExtent TEXT NOT NULL, Param TEXT NOT NULL, Value TEXT NOT NULL)");
    }

    private void createTestTable() {
        this.updateDb("CREATE TABLE IF NOT EXISTS Test (ReportIDExtent TEXT NOT NULL, TestIDExtent TEXT NOT NULL, TestName TEXT NOT NULL, Status TEXT NOT NULL, Description TEXT, InternalWarning TEXT, StartMillis TIME NOT NULL, EndMillis TIME NOT NULL, StepsPass INTEGER NOT NULL, StepsFail INTEGER NOT NULL, StepsFatal INTEGER NOT NULL, StepsError INTEGER NOT NULL, StepsWarning INTEGER NOT NULL, StepsInfo INTEGER NOT NULL, StepsSkip INTEGER NOT NULL, StepsUnknown INTEGER NOT NULL, ChildNodesCount INTEGER)");
    }

    private void createNodeTable() {
        this.updateDb("CREATE TABLE IF NOT EXISTS Node (NodeIDExtent TEXT NOT NULL, NodeName TEXT NOT NULL, NodeLevel INTEGER NOT NULL, ReportIDExtent TEXT NOT NULL, TestIDExtent TEXT NOT NULL, ParentTestName TEXT NOT NULL, Status TEXT NOT NULL, Description TEXT, StartMillis TIME NOT NULL, EndMillis TIME NOT NULL, ChildNodesCount INTEGER)");
    }

    private void createLogTable() {
        this.updateDb("CREATE TABLE IF NOT EXISTS Log (ReportIDExtent TEXT NOT NULL, TestIDExtent TEXT NOT NULL, TestName TEXT NOT NULL, LogID INTEGER NOT NULL, Status TEXT NOT NULL, StepName TEXT, Details TEXT, Timestamp TIME NOT NULL)");
    }

    private void createCategoryTable() {
        this.updateDb("CREATE TABLE IF NOT EXISTS Category ( ReportIDExtent TEXT NOT NULL, TestIDExtent TEXT NOT NULL, TestName TEXT NOT NULL, CategoryName TEXT NOT NULL)");
    }

    private PreparedStatement getPreparedStatement(String query) {
        try {
            return this.connection.prepareStatement(query);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void updateDb(String query) {
        try {
            Statement stmt = this.connection.createStatement();
            stmt.executeUpdate(query);
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    public void setTestRunnerLogs() {
    }

    public DBReporter(String filePath) {
        this.filePath = filePath;
    }

    public class Config {
    }
}

