/*
 * Decompiled with CFR 0.152.
 */
package com.relops.snowflake;

public class Snowflake {
    public static final int NODE_SHIFT = 10;
    public static final int SEQ_SHIFT = 12;
    public static final short MAX_NODE = 1024;
    public static final short MAX_SEQUENCE = 4096;
    private short sequence;
    private long referenceTime;
    private int node;

    public Snowflake(int node) {
        if (node < 0 || node > 1024) {
            throw new IllegalArgumentException(String.format("node must be between %s and %s", 0, (short)1024));
        }
        this.node = node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long next() {
        long counter;
        long currentTime = System.currentTimeMillis();
        Snowflake snowflake = this;
        synchronized (snowflake) {
            if (currentTime < this.referenceTime) {
                throw new RuntimeException(String.format("Last referenceTime %s is after reference time %s", this.referenceTime, currentTime));
            }
            if (currentTime > this.referenceTime) {
                this.sequence = 0;
            } else if (this.sequence < 4096) {
                this.sequence = (short)(this.sequence + 1);
            } else {
                throw new RuntimeException("Sequence exhausted at " + this.sequence);
            }
            counter = this.sequence;
            this.referenceTime = currentTime;
        }
        return currentTime << 10 << 12 | (long)(this.node << 12) | counter;
    }
}

