/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.propertypath.impl;

import com.remondis.propertypath.api.Get;
import com.remondis.propertypath.api.GetAndApply;
import com.remondis.propertypath.api.PropertyPath;
import com.remondis.propertypath.impl.GetAndApplyImpl;
import com.remondis.propertypath.impl.InvocationSensor;
import com.remondis.propertypath.impl.PropertyPathException;
import com.remondis.propertypath.impl.TypedTransitiveProperty;
import com.remondis.propertypath.impl.exceptions.ExceptionInPropertyPath;
import com.remondis.propertypath.impl.exceptions.NotAValidPropertyPathException;
import com.remondis.propertypath.impl.exceptions.ZeroInteractionException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public final class GetImpl<I, O, E extends Exception>
implements Get<I, O, E> {
    private Class<I> startType;
    private TypedTransitiveProperty<I, O, E> sourceProperty;

    public GetImpl(Class<I> startType, PropertyPath<O, I, E> selector) {
        this.startType = startType;
        this.sourceProperty = GetImpl.buildTransitiveProperty(startType, selector);
    }

    @Override
    public <X> GetAndApply<I, O, X, E> andApply(Function<O, X> mapping) {
        return new GetAndApplyImpl(this, mapping);
    }

    @Override
    public Optional<O> from(I object) throws E {
        if (Objects.isNull(object)) {
            return Optional.empty();
        }
        O evaluationValue = this.sourceProperty.get(object);
        if (Objects.isNull(evaluationValue)) {
            return Optional.empty();
        }
        return Optional.ofNullable(evaluationValue);
    }

    protected TypedTransitiveProperty<I, O, E> getTransitiveProperty() {
        return this.sourceProperty;
    }

    protected Class<I> getStartType() {
        return this.startType;
    }

    protected static <I, X, E extends Exception> TypedTransitiveProperty<I, X, E> buildTransitiveProperty(Class<I> startType, PropertyPath<X, I, E> selector) {
        try {
            return InvocationSensor.getTransitiveTypedProperty(startType, selector);
        }
        catch (ZeroInteractionException e) {
            throw new PropertyPathException("The specified property path did not interact with the given object.", e);
        }
        catch (ExceptionInPropertyPath e) {
            throw new PropertyPathException("The specified property path threw an exception.", e);
        }
        catch (NotAValidPropertyPathException e) {
            throw new PropertyPathException("The specified property path contained illegal method calls. Only getters and calls to List.get(int) and Map.get(Object) are allowed!", e);
        }
    }

    @Override
    public O fromOrDefault(I object, O defaultValue) throws E {
        Optional<O> optional = this.from(object);
        if (optional.isPresent()) {
            return optional.get();
        }
        return defaultValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sourceProperty == null ? 0 : this.sourceProperty.hashCode());
        result = 31 * result + (this.startType == null ? 0 : this.startType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetImpl other = (GetImpl)obj;
        if (this.sourceProperty == null ? other.sourceProperty != null : !this.sourceProperty.equals(other.sourceProperty)) {
            return false;
        }
        return !(this.startType == null ? other.startType != null : !this.startType.equals(other.startType));
    }

    public String toString() {
        return this.sourceProperty.toString(false);
    }

    @Override
    public String toString(boolean detailed) {
        return this.sourceProperty.toString(detailed);
    }
}

