/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.propertypath.impl;

import com.remondis.propertypath.impl.InvocationSensor;
import com.remondis.propertypath.impl.Properties;
import com.remondis.propertypath.impl.PropertyPathException;
import com.remondis.propertypath.impl.ReflectionUtil;
import com.remondis.propertypath.impl.exceptions.NotAValidPropertyPathException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class TypedTransitiveProperty<T, R, E extends Exception> {
    private List<InvocationSensor.Invocation> invocations;
    private Class<T> rootType;

    TypedTransitiveProperty(Class<T> sensorType, R returnValue, List<InvocationSensor.Invocation> invocations) {
        this.rootType = sensorType;
        this.invocations = invocations;
    }

    public R get(T rootTargetInstance) throws E {
        try {
            Object currentTarget = rootTargetInstance;
            for (InvocationSensor.Invocation invocation : this.invocations) {
                Object returnValue;
                block11: {
                    Object[] args = invocation.getArgs();
                    returnValue = null;
                    if (args.length == 0) {
                        returnValue = invocation.getMethod().invoke(currentTarget, new Object[0]);
                    } else {
                        try {
                            returnValue = invocation.getMethod().invoke(currentTarget, args);
                        }
                        catch (InvocationTargetException e) {
                            if (!(e.getTargetException() instanceof IndexOutOfBoundsException)) break block11;
                            return null;
                        }
                    }
                }
                if (Objects.isNull(returnValue)) {
                    return null;
                }
                currentTarget = returnValue;
            }
            return (R)currentTarget;
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            try {
                throw (Exception)targetException;
            }
            catch (ClassCastException castException) {
                throw PropertyPathException.accessError(this.rootType, this.invocations, targetException);
            }
        }
        catch (Exception e) {
            throw PropertyPathException.accessError(this.rootType, this.invocations, e);
        }
    }

    public static <T, R, E extends Exception> TypedTransitiveProperty<T, R, E> of(Class<T> sensorType, R returnValue, List<InvocationSensor.Invocation> trackedInvocations) throws NotAValidPropertyPathException {
        boolean valid = false;
        Class<Object> currentType = sensorType;
        Iterator<InvocationSensor.Invocation> iterator = trackedInvocations.iterator();
        do {
            InvocationSensor.Invocation invocation = iterator.next();
            if (ReflectionUtil.isList(currentType) || ReflectionUtil.isMap(currentType)) {
                valid = invocation.getMethod().getName().equals("get");
                currentType = invocation.getGenericReturnType();
            } else {
                Optional<PropertyDescriptor> property = Properties.getProperties(currentType).stream().filter(pd -> Objects.nonNull(pd.getReadMethod())).filter(pd -> pd.getReadMethod().equals(invocation.getMethod())).findFirst();
                valid = property.isPresent();
                if (valid) {
                    currentType = property.get().getPropertyType();
                }
            }
            if (valid) continue;
            throw NotAValidPropertyPathException.notAValidPropertyPath(sensorType, trackedInvocations);
        } while (iterator.hasNext() && valid);
        return new TypedTransitiveProperty<T, R, E>(sensorType, returnValue, trackedInvocations);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean detailed) {
        StringBuilder b = new StringBuilder(detailed ? this.rootType.getName() : this.rootType.getSimpleName());
        for (InvocationSensor.Invocation i : this.invocations) {
            b.append(".").append(i.toString());
        }
        return b.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.invocations == null ? 0 : this.invocations.hashCode());
        result = 31 * result + (this.rootType == null ? 0 : this.rootType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypedTransitiveProperty other = (TypedTransitiveProperty)obj;
        if (this.invocations == null ? other.invocations != null : !this.invocations.equals(other.invocations)) {
            return false;
        }
        return !(this.rootType == null ? other.rootType != null : !this.rootType.equals(other.rootType));
    }
}

