/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.propertypath.impl;

import com.remondis.propertypath.api.AssertGetterAndApplyBuilder;
import com.remondis.propertypath.api.AssertGetterBuilder;
import com.remondis.propertypath.api.Get;
import com.remondis.propertypath.api.GetAndApply;
import com.remondis.propertypath.api.PropertyPath;
import com.remondis.propertypath.impl.GetAndApplyImpl;
import com.remondis.propertypath.impl.GetImpl;
import com.remondis.propertypath.impl.TypedTransitiveProperty;

public class AssertGetterBuilderImpl<I, O, T, E extends Exception>
implements AssertGetterBuilder<I, O, E>,
AssertGetterAndApplyBuilder<I, O, T, E> {
    private GetImpl<I, O, E> getter;

    public AssertGetterBuilderImpl(Get<I, O, E> getter) {
        this.checkGetImpl(getter);
        this.getter = (GetImpl)getter;
    }

    private void checkGetImpl(Get<I, O, E> getter) {
        if (!(getter instanceof GetImpl)) {
            throw new IllegalArgumentException("The type of getter instance is not supported. Needs to be GetImpl.");
        }
    }

    public AssertGetterBuilderImpl(GetAndApply<I, O, T, E> getter) {
        this.checkGetAndApply(getter);
        GetAndApplyImpl impl = (GetAndApplyImpl)getter;
        Get originalGetter = impl.getGetter();
        this.checkGetImpl(originalGetter);
        this.getter = (GetImpl)originalGetter;
    }

    private void checkGetAndApply(GetAndApply<I, O, T, E> getter) {
        if (!(getter instanceof GetAndApplyImpl)) {
            throw new IllegalArgumentException("The type of getter instance is not supported. Needs to be GetAndApplyImpl.");
        }
    }

    @Override
    public void assertGetter(PropertyPath<O, I, E> selector) {
        this.assertPropertyPath(selector);
    }

    private void assertPropertyPath(PropertyPath<?, I, E> selector) throws AssertionError {
        TypedTransitiveProperty<I, ?, E> expectedProperty;
        TypedTransitiveProperty<I, O, E> actualProperty = this.getter.getTransitiveProperty();
        if (!actualProperty.equals(expectedProperty = GetImpl.buildTransitiveProperty(this.getter.getStartType(), selector))) {
            throw new AssertionError((Object)("The expected propertypath does not match the actual property path of this getter:\nExpected: " + expectedProperty.toString(true) + "\n  Actual: " + actualProperty.toString(true)));
        }
    }
}

