/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.propertypath.impl;

import com.remondis.propertypath.api.Get;
import com.remondis.propertypath.api.GetAndApply;
import com.remondis.propertypath.api.GetWithoutException;
import com.remondis.propertypath.impl.GetWithoutExceptionImpl;
import java.util.Optional;
import java.util.function.Function;

public class GetAndApplyImpl<I, O, T, E extends Exception>
implements GetAndApply<I, O, T, E> {
    private Get<I, O, E> getter;
    private Function<O, T> mapping;

    public GetAndApplyImpl(Get<I, O, E> getter, Function<O, T> mapping) {
        this.getter = getter;
        this.mapping = mapping;
    }

    @Override
    public GetWithoutException<I, T> toJdk8() {
        return new GetWithoutExceptionImpl(this);
    }

    Get<I, O, E> getGetter() {
        return this.getter;
    }

    Function<O, T> getMapping() {
        return this.mapping;
    }

    @Override
    public Optional<T> from(I object) throws E {
        Optional<O> opt = this.getter.from(object);
        if (opt.isPresent()) {
            return Optional.ofNullable(this.mapping.apply(opt.get()));
        }
        return Optional.empty();
    }

    @Override
    public T fromOrDefault(I object, T defaultValue) throws E {
        Optional<T> opt = this.from(object);
        if (opt.isPresent()) {
            return opt.get();
        }
        return defaultValue;
    }

    @Override
    public <X> GetAndApply<I, T, X, E> andApply(Function<T, X> mapping) {
        return new GetAndApplyImpl<I, T, X, E>(this, mapping);
    }

    @Override
    public String toString(boolean detailed) {
        return this.getter.toString(detailed) + " and applying a mapping function!";
    }

    @Override
    public String toPath() {
        return this.getter.toPath();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getter == null ? 0 : this.getter.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetAndApplyImpl other = (GetAndApplyImpl)obj;
        return !(this.getter == null ? other.getter != null : !this.getter.equals(other.getter));
    }
}

