/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.propertypath.impl;

import com.remondis.propertypath.api.PropertyPath;
import com.remondis.propertypath.impl.ReflectionUtil;
import com.remondis.propertypath.impl.TypedTransitiveProperty;
import com.remondis.propertypath.impl.exceptions.ExceptionInPropertyPath;
import com.remondis.propertypath.impl.exceptions.NotAValidPropertyPathException;
import com.remondis.propertypath.impl.exceptions.ReflectionException;
import com.remondis.propertypath.impl.exceptions.ZeroInteractionException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.InvocationHandler;
import net.sf.cglib.proxy.UndeclaredThrowableException;

public class InvocationSensor<T> {
    private T proxyObject;
    private List<Invocation> invocations = new LinkedList<Invocation>();
    private Class<T> superType;

    InvocationSensor(Class<T> superType) {
        this.superType = superType;
    }

    private T createProxy(Class<T> superType, boolean supportTransitiveCalls) {
        Enhancer enhancer = this.createProxyObject(superType, supportTransitiveCalls);
        return superType.cast(enhancer.create());
    }

    private Enhancer createProxyObject(final Class<?> superType, final boolean supportTransitiveCalls) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(superType);
        enhancer.setCallback((Callback)new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Invocation invocation = new Invocation(method, args);
                if (ReflectionUtil.isGetterWithArgumentSupport(method)) {
                    ReflectionUtil.denyNoReturnType(method);
                    InvocationSensor.this.invocations.add(invocation);
                    if (supportTransitiveCalls) {
                        Class<?> returnType = method.getReturnType();
                        if (ReflectionUtil.isMap(returnType) || ReflectionUtil.isList(returnType)) {
                            int typeIndex = ReflectionUtil.isMap(returnType) ? 1 : 0;
                            Class<?> genericType = ReflectionUtil.findGenericTypeFromMethod(method, typeIndex);
                            Enhancer enhancer = InvocationSensor.this.createCollectionProxyObject(returnType, genericType);
                            return returnType.cast(enhancer.create());
                        }
                        if (ReflectionUtil.isBean(returnType)) {
                            Enhancer enhancer = InvocationSensor.this.createProxyObject(returnType, supportTransitiveCalls);
                            return returnType.cast(enhancer.create());
                        }
                        return ReflectionUtil.nullOrDefaultValue(method.getReturnType());
                    }
                    return ReflectionUtil.nullOrDefaultValue(method.getReturnType());
                }
                throw NotAValidPropertyPathException.notAValidPropertyPath(superType, Arrays.asList(invocation));
            }
        });
        return enhancer;
    }

    private Enhancer createCollectionProxyObject(final Class<?> superType, final Class<?> genericType) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(superType);
        enhancer.setCallback((Callback)new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Invocation invocation = new Invocation(method, genericType, args);
                if (ReflectionUtil.isGetterWithArgumentSupport(method)) {
                    ReflectionUtil.denyNoReturnType(method);
                    InvocationSensor.this.invocations.add(invocation);
                    Class returnType = genericType;
                    if (ReflectionUtil.isMap(returnType) || ReflectionUtil.isList(returnType)) {
                        int typeIndex = ReflectionUtil.isMap(returnType) ? 1 : 0;
                        Class<?> genericType2 = ReflectionUtil.findGenericTypeFromMethod(method, typeIndex);
                        Enhancer enhancer = InvocationSensor.this.createCollectionProxyObject(returnType, genericType2);
                        return returnType.cast(enhancer.create());
                    }
                    if (ReflectionUtil.isBean(returnType)) {
                        Enhancer enhancer = InvocationSensor.this.createProxyObject(returnType, true);
                        return returnType.cast(enhancer.create());
                    }
                    return ReflectionUtil.nullOrDefaultValue(method.getReturnType());
                }
                throw NotAValidPropertyPathException.notAValidPropertyPath(superType, Arrays.asList(invocation));
            }
        });
        return enhancer;
    }

    private T getSensor(boolean supportTransitiveCalls) {
        this.proxyObject = this.createProxy(this.superType, supportTransitiveCalls);
        return this.proxyObject;
    }

    List<Invocation> getTrackedInvocations() {
        return Collections.unmodifiableList(this.invocations);
    }

    boolean hasTrackedInvocations() {
        return !this.invocations.isEmpty();
    }

    public static <R, T, E extends Exception> TypedTransitiveProperty<T, R, E> getTransitiveTypedProperty(Class<T> sensorType, PropertyPath<R, T, E> selector) throws ZeroInteractionException, ExceptionInPropertyPath, NotAValidPropertyPathException {
        InvocationSensor<T> invocationSensor = new InvocationSensor<T>(sensorType);
        T sensor = super.getSensor(true);
        try {
            R returnValue = selector.selectProperty(sensor);
            if (invocationSensor.hasTrackedInvocations()) {
                List<Invocation> trackedInvocations = invocationSensor.getTrackedInvocations();
                return TypedTransitiveProperty.of(sensorType, returnValue, trackedInvocations);
            }
            throw ZeroInteractionException.zeroInteractions(sensorType);
        }
        catch (UndeclaredThrowableException e) {
            Throwable undeclaredThrowable = e.getUndeclaredThrowable();
            if (undeclaredThrowable instanceof NotAValidPropertyPathException) {
                throw (NotAValidPropertyPathException)undeclaredThrowable;
            }
            throw e;
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (Exception exception) {
            throw ExceptionInPropertyPath.exceptionInPropertyPath(sensorType, exception);
        }
    }

    public static class Invocation {
        private Method method;
        private Object[] args;
        private Class<?> genericReturnType;

        Invocation(Method method, Object[] args) {
            this.method = method;
            this.args = args;
        }

        Invocation(Method method, Class<?> genericReturnType, Object[] args) {
            this.method = method;
            this.genericReturnType = genericReturnType;
            this.args = args;
        }

        public Class<?> getGenericReturnType() {
            return this.genericReturnType;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.args);
            result = 31 * result + (this.genericReturnType == null ? 0 : this.genericReturnType.hashCode());
            result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Invocation other = (Invocation)obj;
            if (!Arrays.equals(this.args, other.args)) {
                return false;
            }
            if (this.genericReturnType == null ? other.genericReturnType != null : !this.genericReturnType.equals(other.genericReturnType)) {
                return false;
            }
            return !(this.method == null ? other.method != null : !this.method.equals(other.method));
        }

        public String toString() {
            return this.getMethod().getName() + "(" + Arrays.toString(this.getArgs()).replaceAll("\\[|\\]", "") + ")";
        }

        public static String invocationsToString(List<Invocation> invocations) {
            StringBuilder b = new StringBuilder();
            Iterator<Invocation> it = invocations.iterator();
            while (it.hasNext()) {
                Invocation invocation = it.next();
                b.append(invocation.getMethod().getName()).append("(");
                b.append(Arrays.toString(invocation.getArgs()).replaceAll("\\[|\\]", "")).append(")");
                if (!it.hasNext()) continue;
                b.append(".");
            }
            return b.toString();
        }
    }
}

