/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.propertypath.impl;

import com.remondis.propertypath.impl.PropertyPathException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

class Properties {
    Properties() {
    }

    static Set<PropertyDescriptor> getProperties(Class<?> inspectType) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(inspectType);
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            return new HashSet<PropertyDescriptor>(Arrays.asList(propertyDescriptors).stream().filter(pd -> !pd.getName().equals("class")).collect(Collectors.toList()));
        }
        catch (IntrospectionException e) {
            throw new PropertyPathException(String.format("Cannot introspect the type %s.", inspectType.getName()));
        }
    }
}

