/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.propertypath.impl;

import com.remondis.propertypath.impl.InvocationSensor;
import com.remondis.propertypath.impl.PropertyPathException;
import java.beans.Introspector;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ReflectionUtil {
    static final String IS = "is";
    static final String GET = "get";
    static final String SET = "set";
    private static final Set<Class<?>> BUILD_IN_TYPES;
    private static final Map<Class<?>, Object> DEFAULT_VALUES;
    private static final Map<String, Class<?>> primitiveNameMap;
    private static final Map<Class<?>, Class<?>> wrapperMap;

    ReflectionUtil() {
    }

    public static boolean isBuildInType(Class<?> type) {
        return BUILD_IN_TYPES.contains(type);
    }

    static <T> T defaultValue(Class<T> type) {
        return (T)DEFAULT_VALUES.get(type);
    }

    static boolean hasReturnType(Method method) {
        return !method.getReturnType().equals(Void.TYPE);
    }

    static boolean isGetterWithArgumentSupport(Method method) {
        boolean isBool = ReflectionUtil.isBoolGetter(method);
        boolean validName = isBool ? method.getName().startsWith(IS) : method.getName().startsWith(GET);
        boolean hasReturnType = ReflectionUtil.hasReturnType(method);
        return validName && hasReturnType;
    }

    static Class<?> findGenericTypeFromMethod(Method method, int typeIndex) {
        ParameterizedType parameterizedType = (ParameterizedType)method.getGenericReturnType();
        Type type = null;
        while (parameterizedType != null) {
            type = parameterizedType.getActualTypeArguments()[typeIndex];
            if (type instanceof ParameterizedType) {
                parameterizedType = (ParameterizedType)type;
                continue;
            }
            parameterizedType = null;
        }
        return (Class)type;
    }

    static boolean isBoolGetter(Method method) {
        return ReflectionUtil.isBool(method.getReturnType());
    }

    static boolean isBool(Class<?> type) {
        return type == Boolean.TYPE;
    }

    public static boolean isBean(Class<?> type) {
        try {
            type.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return !ReflectionUtil.isBuildInType(type);
    }

    public static void denyNoReturnType(Method method) {
        if (!ReflectionUtil.hasReturnType(method)) {
            throw PropertyPathException.noReturnTypeOnGetter(method);
        }
    }

    public static Object nullOrDefaultValue(Class<?> returnType) {
        if (returnType.isPrimitive()) {
            return ReflectionUtil.defaultValue(returnType);
        }
        return null;
    }

    public static boolean isList(Class<?> returnType) {
        return List.class.isAssignableFrom(returnType);
    }

    public static boolean isMap(Class<?> returnType) {
        return Map.class.isAssignableFrom(returnType);
    }

    static String toPropertyName(InvocationSensor.Invocation invocation) {
        Method method = invocation.getMethod();
        String name = method.getName();
        if (ReflectionUtil.isBoolGetter(method)) {
            return ReflectionUtil.firstCharacterToLowerCase(name.substring(2, name.length()));
        }
        if (ReflectionUtil.isGetterWithArgumentSupport(method)) {
            if (ReflectionUtil.isList(method.getDeclaringClass())) {
                String argument = invocation.getArgs()[0].toString();
                return "[" + argument + "]";
            }
            return Introspector.decapitalize(name.substring(3, name.length()));
        }
        throw new IllegalArgumentException("The specified method is neither a getter nor a setter method.");
    }

    private static String firstCharacterToLowerCase(String input) {
        char[] c = input.toCharArray();
        c[0] = Character.toLowerCase(c[0]);
        return new String(c);
    }

    static boolean hasArguments(Method method) {
        return method.getParameterCount() != 0;
    }

    static {
        HashMap<Class<Comparable<Boolean>>, Comparable<Boolean>> map = new HashMap<Class<Comparable<Boolean>>, Comparable<Boolean>>();
        map.put(Boolean.TYPE, Boolean.valueOf(false));
        map.put(Character.TYPE, Character.valueOf('\u0000'));
        map.put(Byte.TYPE, Byte.valueOf((byte)0));
        map.put(Short.TYPE, Short.valueOf((short)0));
        map.put(Integer.TYPE, Integer.valueOf(0));
        map.put(Long.TYPE, Long.valueOf(0L));
        map.put(Float.TYPE, Float.valueOf(0.0f));
        map.put(Double.TYPE, Double.valueOf(0.0));
        DEFAULT_VALUES = Collections.unmodifiableMap(map);
        BUILD_IN_TYPES = new HashSet();
        BUILD_IN_TYPES.add(Boolean.class);
        BUILD_IN_TYPES.add(Character.class);
        BUILD_IN_TYPES.add(Byte.class);
        BUILD_IN_TYPES.add(Short.class);
        BUILD_IN_TYPES.add(Integer.class);
        BUILD_IN_TYPES.add(Long.class);
        BUILD_IN_TYPES.add(Float.class);
        BUILD_IN_TYPES.add(Double.class);
        BUILD_IN_TYPES.add(String.class);
        primitiveNameMap = new HashMap();
        wrapperMap = new HashMap();
        primitiveNameMap.put(Boolean.TYPE.getName(), Boolean.TYPE);
        primitiveNameMap.put(Byte.TYPE.getName(), Byte.TYPE);
        primitiveNameMap.put(Character.TYPE.getName(), Character.TYPE);
        primitiveNameMap.put(Short.TYPE.getName(), Short.TYPE);
        primitiveNameMap.put(Integer.TYPE.getName(), Integer.TYPE);
        primitiveNameMap.put(Long.TYPE.getName(), Long.TYPE);
        primitiveNameMap.put(Double.TYPE.getName(), Double.TYPE);
        primitiveNameMap.put(Float.TYPE.getName(), Float.TYPE);
        primitiveNameMap.put(Void.TYPE.getName(), Void.TYPE);
        wrapperMap.put(Boolean.TYPE, Boolean.class);
        wrapperMap.put(Byte.TYPE, Byte.class);
        wrapperMap.put(Character.TYPE, Character.class);
        wrapperMap.put(Short.TYPE, Short.class);
        wrapperMap.put(Integer.TYPE, Integer.class);
        wrapperMap.put(Long.TYPE, Long.class);
        wrapperMap.put(Double.TYPE, Double.class);
        wrapperMap.put(Float.TYPE, Float.class);
        wrapperMap.put(Void.TYPE, Void.class);
    }
}

