/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap;

import com.remondis.remap.MappingException;
import com.remondis.remap.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.InvocationHandler;

class InvocationSensor<T> {
    private T proxyObject;
    private List<String> propertyNames = new LinkedList<String>();

    InvocationSensor(Class<T> superType) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(superType);
        enhancer.setCallback((Callback)new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (ReflectionUtil.isGetter(method)) {
                    InvocationSensor.this.denyNoReturnType(method);
                    String propertyName = ReflectionUtil.toPropertyName(method);
                    InvocationSensor.this.propertyNames.add(propertyName);
                    return InvocationSensor.nullOrDefaultValue(method.getReturnType());
                }
                if (InvocationSensor.isObjectMethod(method)) {
                    return ReflectionUtil.invokeMethodProxySafe(method, this, args);
                }
                return InvocationSensor.nullOrDefaultValue(method.getReturnType());
            }
        });
        this.proxyObject = superType.cast(enhancer.create());
    }

    T getSensor() {
        return this.proxyObject;
    }

    List<String> getTrackedPropertyNames() {
        return Collections.unmodifiableList(this.propertyNames);
    }

    boolean hasTrackedProperties() {
        return !this.propertyNames.isEmpty();
    }

    void reset() {
        this.propertyNames.clear();
    }

    private void denyNoReturnType(Method method) {
        if (!ReflectionUtil.hasReturnType(method)) {
            throw MappingException.noReturnTypeOnGetter(method);
        }
    }

    private static Object nullOrDefaultValue(Class<?> returnType) {
        if (returnType.isPrimitive()) {
            return ReflectionUtil.defaultValue(returnType);
        }
        return null;
    }

    private static boolean isObjectMethod(Method method) {
        return method.getDeclaringClass() == Object.class;
    }
}

