/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap;

import com.remondis.remap.Lang;
import com.remondis.remap.MappedResult;
import com.remondis.remap.MappingConfiguration;
import com.remondis.remap.MappingException;
import com.remondis.remap.Properties;
import com.remondis.remap.Transformation;
import java.beans.PropertyDescriptor;
import java.util.Objects;

class OmitTransformation
extends Transformation {
    private static final String OMITTING_MSG = "Omitting %s";

    private OmitTransformation(MappingConfiguration<?, ?> mapping, PropertyDescriptor sourceProperty, PropertyDescriptor destinationProperty) {
        super(mapping, sourceProperty, destinationProperty);
    }

    static OmitTransformation omitDestination(MappingConfiguration<?, ?> mapping, PropertyDescriptor destinationProperty) {
        Lang.denyNull("mapping", mapping);
        Lang.denyNull("destinationProperty", destinationProperty);
        return new OmitTransformation(mapping, null, destinationProperty);
    }

    public boolean isOmitInDestination() {
        return Objects.nonNull(this.destinationProperty);
    }

    public boolean isOmitInSource() {
        return Objects.nonNull(this.sourceProperty);
    }

    static OmitTransformation omitSource(MappingConfiguration<?, ?> mapping, PropertyDescriptor sourceProperty) {
        Lang.denyNull("mapping", mapping);
        Lang.denyNull("destinationProperty", sourceProperty);
        return new OmitTransformation(mapping, sourceProperty, null);
    }

    @Override
    protected void performTransformation(PropertyDescriptor sourceProperty, Object source, PropertyDescriptor destinationProperty, Object destination) throws MappingException {
    }

    @Override
    protected MappedResult performValueTransformation(Object source, Object destination) throws MappingException {
        return MappedResult.skip();
    }

    @Override
    protected void validateTransformation() throws MappingException {
    }

    @Override
    public String toString(boolean detailed) {
        if (this.sourceProperty != null) {
            return String.format(OMITTING_MSG, Properties.asString(this.sourceProperty, detailed));
        }
        return String.format(OMITTING_MSG, Properties.asString(this.destinationProperty, detailed));
    }
}

