/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap;

import com.remondis.remap.MappingException;
import com.remondis.remap.Target;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

class Properties {
    Properties() {
    }

    static String asStringWithType(PropertyDescriptor pd) {
        return Properties.asStringWithType(pd, false);
    }

    static String asStringWithType(PropertyDescriptor pd, boolean detailed) {
        Class<?> clazz = Properties.getPropertyClass(pd);
        return String.format("Property '%s' (%s) in %s", pd.getName(), pd.getPropertyType().getName(), detailed ? clazz.getName() : clazz.getSimpleName());
    }

    static String asString(PropertyDescriptor pd) {
        return Properties.asString(pd, false);
    }

    static String asString(PropertyDescriptor pd, boolean detailed) {
        Class<?> clazz = Properties.getPropertyClass(pd);
        return String.format("Property '%s' in %s", pd.getName(), detailed ? clazz.getName() : clazz.getSimpleName());
    }

    static Class<?> getPropertyClass(PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getReadMethod().getDeclaringClass();
    }

    static String createUnmappedMessage(Set<PropertyDescriptor> unmapped) {
        StringBuilder msg = new StringBuilder("The following properties are unmapped:\n");
        for (PropertyDescriptor pd : unmapped) {
            String getter = pd.getReadMethod().getName();
            Method writeMethod = pd.getWriteMethod();
            String setter = Objects.isNull(writeMethod) ? "none" : writeMethod.getName();
            msg.append("- ").append(Properties.asString(pd)).append("\n\taccess methods: ").append(getter).append("() / ").append(setter).append("()\n");
        }
        return msg.toString();
    }

    static Set<PropertyDescriptor> getProperties(Class<?> inspectType, Target targetType) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(inspectType);
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            return new HashSet<PropertyDescriptor>(Arrays.asList(propertyDescriptors).stream().filter(pd -> !pd.getName().equals("class")).filter(Properties::hasGetter).filter(pd -> {
                if (Target.SOURCE.equals((Object)targetType)) {
                    return true;
                }
                return Properties.hasSetter(pd);
            }).collect(Collectors.toList()));
        }
        catch (IntrospectionException e) {
            throw new MappingException(String.format("Cannot introspect the type %s.", inspectType.getName()));
        }
    }

    private static boolean hasGetter(PropertyDescriptor pd) {
        return pd.getReadMethod() != null;
    }

    private static boolean hasSetter(PropertyDescriptor pd) {
        return pd.getWriteMethod() != null;
    }
}

