/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap;

import com.remondis.propertypath.api.Get;
import com.remondis.propertypath.api.Getter;
import com.remondis.propertypath.api.PropertyPath;
import com.remondis.remap.MappedResult;
import com.remondis.remap.MappingConfiguration;
import com.remondis.remap.MappingException;
import com.remondis.remap.Properties;
import com.remondis.remap.Transformation;
import java.beans.PropertyDescriptor;
import java.util.Optional;
import java.util.function.Function;

public class PropertyPathTransformation<RS, X, RD>
extends Transformation {
    private static final String PROPERTY_PATH_MSG = "Replacing %s\n           with %s\n           using property path%s: %s";
    private Get<RS, RD, ?> propertyPath;
    private boolean hasTransformation;

    PropertyPathTransformation(MappingConfiguration<?, ?> mapping, PropertyDescriptor sourceProperty, PropertyDescriptor destinationProperty, PropertyPath<RD, RS, ?> propertyPath) {
        super(mapping, sourceProperty, destinationProperty);
        this.propertyPath = this.createGetter(sourceProperty, propertyPath);
    }

    PropertyPathTransformation(MappingConfiguration<?, ?> mapping, PropertyDescriptor sourceProperty, PropertyDescriptor destinationProperty, PropertyPath<X, RS, ?> propertyPath, Function<X, RD> transformation) {
        super(mapping, sourceProperty, destinationProperty);
        this.propertyPath = this.createGetterAndApply(sourceProperty, propertyPath, transformation);
        this.hasTransformation = true;
    }

    private Get<RS, RD, ?> createGetter(PropertyDescriptor sourceProperty, PropertyPath<RD, RS, ?> propertyPath) {
        return Getter.newFor(sourceProperty.getPropertyType()).evaluate(propertyPath);
    }

    private Get<RS, RD, ?> createGetterAndApply(PropertyDescriptor sourceProperty, PropertyPath<X, RS, ?> propertyPath, Function<X, RD> transformation) {
        return Getter.newFor(sourceProperty.getPropertyType()).evaluate(propertyPath).andApply(transformation);
    }

    @Override
    protected void performTransformation(PropertyDescriptor sourceProperty, Object source, PropertyDescriptor destinationProperty, Object destination) throws MappingException {
        Object sourceValue = this.readOrFail(sourceProperty, source);
        MappedResult result = this.performValueTransformation(sourceValue, destination);
        if (result.hasValue()) {
            this.writeOrFail(destinationProperty, destination, result.getValue());
        }
    }

    @Override
    protected MappedResult performValueTransformation(Object source, Object destination) throws MappingException {
        if (source == null) {
            return MappedResult.skip();
        }
        try {
            Optional optional = this.propertyPath.from(source);
            if (optional.isPresent()) {
                Object destinationValue = optional.get();
                return MappedResult.value(destinationValue);
            }
            return MappedResult.skip();
        }
        catch (Exception e) {
            throw new MappingException(String.format("The property path for mapping %s to %s evaluating %s failed with an exception.", Properties.asString(this.sourceProperty), Properties.asString(this.destinationProperty), this.propertyPath.toString()), e);
        }
    }

    @Override
    protected void validateTransformation() throws MappingException {
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.hasTransformation ? 1231 : 1237);
        result = 31 * result + (this.propertyPath == null ? 0 : this.propertyPath.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyPathTransformation other = (PropertyPathTransformation)obj;
        if (this.hasTransformation != other.hasTransformation) {
            return false;
        }
        return !(this.propertyPath == null ? other.propertyPath != null : !this.propertyPath.equals(other.propertyPath));
    }

    @Override
    public String toString(boolean detailed) {
        return String.format(PROPERTY_PATH_MSG, Properties.asString(this.sourceProperty, detailed), Properties.asString(this.destinationProperty, detailed), this.hasTransformation ? " with transformation function" : "", this.propertyPath.toString(detailed));
    }
}

