/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap;

import com.remondis.propertypath.api.PropertyPath;
import com.remondis.remap.AssertConfiguration;
import com.remondis.remap.Lang;
import com.remondis.remap.PropertyPathTransformation;
import com.remondis.remap.ReplaceTransformation;
import com.remondis.remap.TypedPropertyDescriptor;
import java.util.function.Function;

public class ReplaceAssertBuilder<S, D, RD, RS> {
    private TypedPropertyDescriptor<RS> sourceProperty;
    private TypedPropertyDescriptor<RD> destProperty;
    private AssertConfiguration<S, D> asserts;

    ReplaceAssertBuilder(TypedPropertyDescriptor<RS> sourceProperty, TypedPropertyDescriptor<RD> destProperty, AssertConfiguration<S, D> asserts) {
        this.sourceProperty = sourceProperty;
        this.destProperty = destProperty;
        this.asserts = asserts;
    }

    public <E extends Exception> AssertConfiguration<S, D> withPropertyPath(PropertyPath<RD, RS, E> propertyPath) {
        Lang.denyNull("propertyPath", propertyPath);
        PropertyPathTransformation replace = new PropertyPathTransformation(this.asserts.getMapping(), this.sourceProperty.property, this.destProperty.property, propertyPath);
        this.asserts.addAssertion(replace);
        return this.asserts;
    }

    public AssertConfiguration<S, D> withPropertyPathAndTransformation(PropertyPath<?, RS, ?> propertyPath) {
        Lang.denyNull("propertyPath", propertyPath);
        PropertyPathTransformation replace = new PropertyPathTransformation(this.asserts.getMapping(), this.sourceProperty.property, this.destProperty.property, propertyPath, Function.identity());
        this.asserts.addAssertion(replace);
        return this.asserts;
    }

    public AssertConfiguration<S, D> andTest(Function<RS, RD> transformation) {
        Lang.denyNull("tranfromation", transformation);
        ReplaceTransformation<RS, RD> replace = new ReplaceTransformation<RS, RD>(this.asserts.getMapping(), this.sourceProperty.property, this.destProperty.property, transformation, false);
        this.asserts.addAssertion(replace);
        return this.asserts;
    }

    public AssertConfiguration<S, D> andSkipWhenNull() {
        ReplaceTransformation replace = new ReplaceTransformation(this.asserts.getMapping(), this.sourceProperty.property, this.destProperty.property, null, true);
        this.asserts.addAssertion(replace);
        return this.asserts;
    }
}

