/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap;

import com.remondis.remap.MappedResult;
import com.remondis.remap.Mapper;
import com.remondis.remap.MappingConfiguration;
import com.remondis.remap.MappingException;
import com.remondis.remap.Properties;
import com.remondis.remap.Transformation;
import java.beans.PropertyDescriptor;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

class RestructureTransformation<S, D, RD>
extends Transformation {
    private static final String MSG_MAPPING = "Restructure complex object for field %s using the following mapping\n%s.";
    private static final String MSG_NO_MAPPING = "Restructure complex object for field %s.";
    private Optional<Supplier<RD>> objectCreator;
    private boolean applyingSpecificConfiguration;
    private Mapper<S, RD> restructureMapper;

    RestructureTransformation(MappingConfiguration<?, ?> mapping, PropertyDescriptor sourceProperty, PropertyDescriptor destinationProperty, Supplier<RD> objectCreator, boolean applyingSpecificConfiguration) {
        super(mapping, null, destinationProperty);
        this.objectCreator = Optional.ofNullable(objectCreator);
        this.applyingSpecificConfiguration = applyingSpecificConfiguration;
    }

    @Override
    protected void performTransformation(PropertyDescriptor sourceProperty, Object source, PropertyDescriptor destinationProperty, Object destination) throws MappingException {
        MappedResult result = this.performValueTransformation(source, destination);
        if (result.hasValue()) {
            this.writeOrFail(destinationProperty, destination, result.getValue());
        }
    }

    @Override
    protected MappedResult performValueTransformation(Object source, Object destination) throws MappingException {
        Object destinationValue = null;
        if (this.objectCreator.isPresent()) {
            RD newObject = this.objectCreator.get().get();
            destinationValue = this.restructureMapper.map(source, newObject);
        } else {
            destinationValue = this.restructureMapper.map(source);
        }
        return MappedResult.value(destinationValue);
    }

    @Override
    protected void validateTransformation() throws MappingException {
        try {
            this.restructureMapper = this.mapping.mapper();
        }
        catch (MappingException e) {
            throw new MappingException("Cannot build mapper for restructuring field " + Properties.asString(this.destinationProperty, true) + ".", e);
        }
    }

    @Override
    public String toString(boolean detailed) {
        if (Objects.isNull(this.restructureMapper)) {
            return String.format(MSG_NO_MAPPING, Properties.asString(this.destinationProperty, detailed));
        }
        return String.format(MSG_MAPPING, Properties.asString(this.destinationProperty, detailed), this.restructureMapper.toString());
    }

    boolean isApplyingSpecificConfiguration() {
        return this.applyingSpecificConfiguration;
    }

    Mapper<S, RD> getRestructureMapper() {
        return this.restructureMapper;
    }
}

