/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap;

import com.remondis.remap.AssertConfiguration;
import com.remondis.remap.AssertVerification;
import com.remondis.remap.Mapper;
import com.remondis.remap.Properties;
import com.remondis.remap.RestructureTransformation;
import com.remondis.remap.RestructuringAssertConfiguration;
import java.beans.PropertyDescriptor;
import java.util.Objects;
import java.util.function.Consumer;

public class RestructureVerification<S, RD>
implements AssertVerification {
    public static final String APPLY_SPECIFIC = "apply specific mapping configuration";
    public static final String CREATE_IMPLICIT = "create implicit mapping";
    private final RestructureTransformation restructureTransformation;
    private final Consumer<RestructuringAssertConfiguration<S, RD>> restructureMappingAssertions;
    private final boolean applyingSpecificConfiguration;

    RestructureVerification(RestructureTransformation restructureTransformation, Consumer<RestructuringAssertConfiguration<S, RD>> restructureMappingAssertions) {
        this.restructureTransformation = restructureTransformation;
        this.restructureMappingAssertions = restructureMappingAssertions;
        this.applyingSpecificConfiguration = Objects.nonNull(restructureMappingAssertions);
    }

    @Override
    public void verify() throws AssertionError {
        Mapper mapper = this.restructureTransformation.getRestructureMapper();
        boolean expected = this.applyingSpecificConfiguration;
        boolean actual = this.restructureTransformation.isApplyingSpecificConfiguration();
        if (expected != actual) {
            PropertyDescriptor destinationProperty = this.restructureTransformation.getDestinationProperty();
            throw new AssertionError((Object)String.format("The mapping from source type %s\nused for restructuring of field %s\nwas configured to %s but was expected to %s.", mapper.getMapping().getSource().getName(), Properties.asString(destinationProperty, true), actual ? APPLY_SPECIFIC : CREATE_IMPLICIT, expected ? APPLY_SPECIFIC : CREATE_IMPLICIT));
        }
        AssertConfiguration assertConfig = new AssertConfiguration(mapper);
        RestructuringAssertConfiguration restructuringAssertConfiguration = new RestructuringAssertConfiguration(assertConfig);
        restructuringAssertConfiguration.expectOtherSourceFieldsToBeOmitted();
        if (this.applyingSpecificConfiguration) {
            this.restructureMappingAssertions.accept(restructuringAssertConfiguration);
        }
        assertConfig = restructuringAssertConfiguration.getDelegate();
        try {
            assertConfig.ensure();
        }
        catch (AssertionError assertionError) {
            PropertyDescriptor destinationProperty = this.restructureTransformation.getDestinationProperty();
            throw new AssertionError((Object)String.format("The mapping from source type %s\nused for restructuring of field in %s\ndid not meet assertions:\n%s", mapper.getMapping().getSource().getName(), Properties.asString(destinationProperty, true), ((Throwable)((Object)assertionError)).getMessage()));
        }
    }
}

