/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Objects;
import java.util.Stack;

public class GenericParameterContext {
    private Stack<ParameterizedType> stack = new Stack();
    private boolean finished = false;
    private Class<?> currentType;
    private Method method;

    public GenericParameterContext(Method method) {
        this.method = method;
        this.init();
    }

    GenericParameterContext(Stack<ParameterizedType> stack, boolean finished, Class<?> currentType, Method method) {
        this.stack = stack;
        this.finished = finished;
        this.currentType = currentType;
        this.method = method;
    }

    private void init() {
        Type genericReturnType = this.method.getGenericReturnType();
        if (genericReturnType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericReturnType;
            this.add(parameterizedType);
            this.currentType = (Class)parameterizedType.getRawType();
        } else if (genericReturnType instanceof TypeVariable) {
            this.currentType = Object.class;
            this.finish();
        } else {
            this.currentType = (Class)genericReturnType;
            this.finish();
        }
    }

    private boolean isEmpty() {
        return this.stack.isEmpty();
    }

    private void add(ParameterizedType parameterizedType) {
        if (this.isFinished()) {
            throw new IllegalStateException("The generic parameter context was finished, the concrete type was found. Further use is not supported.");
        }
        Objects.requireNonNull(parameterizedType, "parameterizedType must not be null.");
        this.stack.push(parameterizedType);
    }

    private boolean isFinished() {
        return this.finished;
    }

    private void finish() {
        this.finished = true;
    }

    public ParameterizedType get() {
        return this.stack.peek();
    }

    public Class<?> getCurrentType() {
        return this.currentType;
    }

    public GenericParameterContext goInto(int genericParameterIndex) {
        Stack<ParameterizedType> newStack = new Stack<ParameterizedType>();
        newStack.addAll(this.stack);
        GenericParameterContext newCtx = new GenericParameterContext(newStack, this.finished, this.currentType, this.method);
        newCtx.findNextGenericTypeFromMethod(genericParameterIndex);
        return newCtx;
    }

    void findNextGenericTypeFromMethod(int genericParameterIndex) {
        Type type = null;
        ParameterizedType parameterizedType = this.get();
        type = parameterizedType.getActualTypeArguments()[genericParameterIndex];
        if (type instanceof ParameterizedType) {
            parameterizedType = (ParameterizedType)type;
            this.add(parameterizedType);
            this.currentType = (Class)parameterizedType.getRawType();
        } else {
            this.finish();
            this.currentType = (Class)type;
        }
    }

    public String toString() {
        return "GenericParameterContext [currentType=" + this.currentType + ", currentParameterizedType=" + (this.isEmpty() ? "empty" : this.get()) + "]";
    }
}

