/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap;

import com.remondis.remap.MappingException;
import java.beans.Introspector;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;

class ReflectionUtil {
    static final String IS = "is";
    static final String GET = "get";
    static final String SET = "set";
    private static final Set<Class<?>> BUILD_IN_TYPES;
    private static final Map<Class<?>, Object> DEFAULT_VALUES;
    private static final Map<String, Class<?>> primitiveNameMap;
    private static final Map<Class<?>, Class<?>> wrapperMap;

    ReflectionUtil() {
    }

    public static boolean isBuildInType(Class<?> type) {
        return BUILD_IN_TYPES.contains(type);
    }

    static <T> T defaultValue(Class<T> type) {
        return (T)DEFAULT_VALUES.get(type);
    }

    static Collector getCollector(Collection collection) {
        if (collection instanceof Set) {
            return Collectors.toSet();
        }
        if (collection instanceof List) {
            return Collectors.toList();
        }
        throw MappingException.unsupportedCollection(collection);
    }

    static Collector getCollector(Class<?> collectionType) {
        if (Set.class.isAssignableFrom(collectionType)) {
            return Collectors.toSet();
        }
        if (List.class.isAssignableFrom(collectionType)) {
            return Collectors.toList();
        }
        throw MappingException.unsupportedCollection(collectionType);
    }

    static boolean hasReturnType(Method method) {
        return !method.getReturnType().equals(Void.TYPE);
    }

    static boolean isGetterOrSetter(Method method) {
        return ReflectionUtil.isGetter(method) || ReflectionUtil.isSetter(method);
    }

    static boolean isSetter(Method method) {
        boolean validName = method.getName().startsWith(SET);
        boolean hasArguments = ReflectionUtil.hasArguments(method, 1);
        boolean hasReturnType = ReflectionUtil.hasReturnType(method);
        return validName && !hasReturnType && hasArguments;
    }

    static boolean isGetter(Method method) {
        boolean isBool = ReflectionUtil.isBoolGetter(method);
        boolean validName = isBool ? method.getName().startsWith(IS) : method.getName().startsWith(GET);
        boolean hasArguments = ReflectionUtil.hasArguments(method);
        boolean hasReturnType = ReflectionUtil.hasReturnType(method);
        return validName && hasReturnType && !hasArguments;
    }

    static boolean isBoolGetter(Method method) {
        return ReflectionUtil.isBool(method.getReturnType());
    }

    static boolean isBool(Class<?> type) {
        return type == Boolean.TYPE;
    }

    static boolean hasArguments(Method method) {
        return method.getParameterCount() != 0;
    }

    static boolean hasArguments(Method method, int count) {
        return method.getParameterCount() == count;
    }

    static String toPropertyName(Method method) {
        String name = method.getName();
        if (ReflectionUtil.isBoolGetter(method)) {
            return ReflectionUtil.firstCharacterToLowerCase(name.substring(2, name.length()));
        }
        if (ReflectionUtil.isGetterOrSetter(method)) {
            return Introspector.decapitalize(name.substring(3, name.length()));
        }
        throw new IllegalArgumentException("The specified method is neither a getter nor a setter method.");
    }

    private static String firstCharacterToLowerCase(String input) {
        char[] c = input.toCharArray();
        c[0] = Character.toLowerCase(c[0]);
        return new String(c);
    }

    static Object invokeMethodProxySafe(Method method, Object targetObject, Object ... args) throws IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        Method effectiveMethod = method;
        Class<?> clazz = targetObject.getClass();
        if (Proxy.isProxyClass(clazz)) {
            effectiveMethod = targetObject.getClass().getMethod(method.getName(), method.getParameterTypes());
        }
        if (args == null) {
            return effectiveMethod.invoke(targetObject, new Object[0]);
        }
        return effectiveMethod.invoke(targetObject, args);
    }

    static <D> D newInstance(Class<D> type) {
        try {
            Constructor<D> constructor = type.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw MappingException.noDefaultConstructor(type, e);
        }
        catch (Exception e) {
            throw MappingException.newInstanceFailed(type, e);
        }
    }

    public static boolean isWrapper(Class<?> type1, Class<?> type2) {
        return type1.isPrimitive() && wrapperMap.get(type1).equals(type2);
    }

    static {
        HashMap<Class<Comparable<Boolean>>, Comparable<Boolean>> map = new HashMap<Class<Comparable<Boolean>>, Comparable<Boolean>>();
        map.put(Boolean.TYPE, Boolean.valueOf(false));
        map.put(Character.TYPE, Character.valueOf('\u0000'));
        map.put(Byte.TYPE, Byte.valueOf((byte)0));
        map.put(Short.TYPE, Short.valueOf((short)0));
        map.put(Integer.TYPE, Integer.valueOf(0));
        map.put(Long.TYPE, Long.valueOf(0L));
        map.put(Float.TYPE, Float.valueOf(0.0f));
        map.put(Double.TYPE, Double.valueOf(0.0));
        DEFAULT_VALUES = Collections.unmodifiableMap(map);
        BUILD_IN_TYPES = new HashSet();
        BUILD_IN_TYPES.add(Boolean.class);
        BUILD_IN_TYPES.add(Character.class);
        BUILD_IN_TYPES.add(Byte.class);
        BUILD_IN_TYPES.add(Short.class);
        BUILD_IN_TYPES.add(Integer.class);
        BUILD_IN_TYPES.add(Long.class);
        BUILD_IN_TYPES.add(Float.class);
        BUILD_IN_TYPES.add(Double.class);
        BUILD_IN_TYPES.add(String.class);
        primitiveNameMap = new HashMap();
        wrapperMap = new HashMap();
        primitiveNameMap.put(Boolean.TYPE.getName(), Boolean.TYPE);
        primitiveNameMap.put(Byte.TYPE.getName(), Byte.TYPE);
        primitiveNameMap.put(Character.TYPE.getName(), Character.TYPE);
        primitiveNameMap.put(Short.TYPE.getName(), Short.TYPE);
        primitiveNameMap.put(Integer.TYPE.getName(), Integer.TYPE);
        primitiveNameMap.put(Long.TYPE.getName(), Long.TYPE);
        primitiveNameMap.put(Double.TYPE.getName(), Double.TYPE);
        primitiveNameMap.put(Float.TYPE.getName(), Float.TYPE);
        primitiveNameMap.put(Void.TYPE.getName(), Void.TYPE);
        wrapperMap.put(Boolean.TYPE, Boolean.class);
        wrapperMap.put(Byte.TYPE, Byte.class);
        wrapperMap.put(Character.TYPE, Character.class);
        wrapperMap.put(Short.TYPE, Short.class);
        wrapperMap.put(Integer.TYPE, Integer.class);
        wrapperMap.put(Long.TYPE, Long.class);
        wrapperMap.put(Double.TYPE, Double.class);
        wrapperMap.put(Float.TYPE, Float.class);
        wrapperMap.put(Void.TYPE, Void.class);
    }
}

