/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap;

import com.remondis.remap.AssertConfiguration;
import com.remondis.remap.Lang;
import com.remondis.remap.RestructureTransformation;
import com.remondis.remap.RestructureVerification;
import com.remondis.remap.RestructuringAssertConfiguration;
import com.remondis.remap.TypedPropertyDescriptor;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class RestructureAssertBuilder<S, D, RD> {
    private TypedPropertyDescriptor<RD> destProperty;
    private AssertConfiguration<S, D> asserts;

    RestructureAssertBuilder(TypedPropertyDescriptor<RD> destProperty, AssertConfiguration<S, D> asserts) {
        this.destProperty = destProperty;
        this.asserts = asserts;
    }

    public AssertConfiguration<S, D> implicitly() {
        return this._assertRestructure(null);
    }

    public AssertConfiguration<S, D> applying(Consumer<RestructuringAssertConfiguration<S, RD>> restructureMappingAssertions) {
        Lang.denyNull("restructureMappingAssertions", restructureMappingAssertions);
        return this._assertRestructure(restructureMappingAssertions);
    }

    private AssertConfiguration<S, D> _assertRestructure(Consumer<RestructuringAssertConfiguration<S, RD>> restructureMappingAssertions) {
        Optional<RestructureTransformation> restructureTransformation = this.asserts.getMapping().getMappings().stream().filter(t -> t instanceof RestructureTransformation).map(t -> (RestructureTransformation)t).filter(t -> t.getDestinationProperty().equals(this.destProperty.property)).findFirst();
        if (restructureTransformation.isPresent()) {
            this.asserts.addVerification(new RestructureVerification<S, RD>(restructureTransformation.get(), restructureMappingAssertions));
        }
        this.asserts.addAssertion(new RestructureTransformation(this.asserts.getMapping(), null, this.destProperty.property, null, Objects.nonNull(restructureMappingAssertions)));
        return this.asserts;
    }
}

