/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap;

import com.remondis.propertypath.api.PropertyPath;
import com.remondis.remap.MappingConfiguration;
import com.remondis.remap.PropertyPathTransformation;
import com.remondis.remap.TypedPropertyDescriptor;
import java.util.Objects;
import java.util.function.Function;

public class PropertyPathAndApplyBuilder<S, D, RD, X, RS, E extends Exception> {
    private MappingConfiguration<S, D> mapping;
    private TypedPropertyDescriptor<RS> sourceProperty;
    private TypedPropertyDescriptor<RD> destProperty;
    private PropertyPath<X, RS, E> propertyPath;

    PropertyPathAndApplyBuilder(MappingConfiguration<S, D> mapping, TypedPropertyDescriptor<RS> sourceProperty, TypedPropertyDescriptor<RD> destProperty, PropertyPath<X, RS, E> propertyPath) {
        this.mapping = mapping;
        this.sourceProperty = sourceProperty;
        this.destProperty = destProperty;
        this.propertyPath = propertyPath;
    }

    public MappingConfiguration<S, D> apply(Function<X, RD> transformation) {
        Objects.requireNonNull(transformation, "Transformation must not be null");
        PropertyPathTransformation<RS, X, RD> replace = new PropertyPathTransformation<RS, X, RD>(this.mapping, this.sourceProperty.property, this.destProperty.property, this.propertyPath, transformation);
        this.mapping.addMapping(this.sourceProperty.property, this.destProperty.property, replace);
        return this.mapping;
    }
}

