/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap;

import com.remondis.propertypath.api.PropertyPath;
import com.remondis.remap.MappingConfiguration;
import com.remondis.remap.PropertyPathCollectionTransformation;
import com.remondis.remap.TypedPropertyDescriptor;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;

public class PropertyPathAndApplyCollectionBuilder<S, D, RD, X, RS, E extends Exception> {
    private MappingConfiguration<S, D> mapping;
    private TypedPropertyDescriptor<Collection<RS>> sourceProperty;
    private TypedPropertyDescriptor<Collection<RD>> destProperty;
    private PropertyPath<X, RS, E> propertyPath;

    PropertyPathAndApplyCollectionBuilder(MappingConfiguration<S, D> mapping, TypedPropertyDescriptor<Collection<RS>> sourceProperty, TypedPropertyDescriptor<Collection<RD>> destProperty, PropertyPath<X, RS, E> propertyPath) {
        this.mapping = mapping;
        this.sourceProperty = sourceProperty;
        this.destProperty = destProperty;
        this.propertyPath = propertyPath;
    }

    public MappingConfiguration<S, D> apply(Function<X, RD> transformation) {
        Objects.requireNonNull(transformation, "Transformation must not be null");
        PropertyPathCollectionTransformation<RS, X, RD> replace = new PropertyPathCollectionTransformation<RS, X, RD>(this.mapping, this.sourceProperty.property, this.destProperty.property, this.propertyPath, transformation);
        this.mapping.addMapping(this.sourceProperty.property, this.destProperty.property, replace);
        return this.mapping;
    }
}

