/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap;

import com.remondis.remap.FieldSelector;
import com.remondis.remap.Lang;
import com.remondis.remap.MappingConfiguration;
import com.remondis.remap.ReassignTransformation;
import com.remondis.remap.Target;
import java.beans.PropertyDescriptor;

public class ReassignBuilder<S, D> {
    static final String ASSIGN = "assign";
    private PropertyDescriptor sourceProperty;
    private MappingConfiguration<S, D> mapping;
    private Class<D> destination;

    ReassignBuilder(PropertyDescriptor sourceProperty, Class<D> destination, MappingConfiguration<S, D> mapping) {
        this.sourceProperty = sourceProperty;
        this.mapping = mapping;
        this.destination = destination;
    }

    public MappingConfiguration<S, D> to(FieldSelector<D> destinationSelector) {
        Lang.denyNull("destinationSelector", destinationSelector);
        PropertyDescriptor destProperty = MappingConfiguration.getPropertyFromFieldSelector(Target.DESTINATION, ASSIGN, this.destination, destinationSelector, this.mapping.isFluentSettersAllowed());
        ReassignTransformation transformation = new ReassignTransformation(this.mapping, this.sourceProperty, destProperty);
        this.mapping.addMapping(this.sourceProperty, destProperty, transformation);
        return this.mapping;
    }
}

