/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap;

import com.remondis.remap.GenericParameterContext;
import com.remondis.remap.InternalMapper;
import com.remondis.remap.MappedResult;
import com.remondis.remap.MappingConfiguration;
import com.remondis.remap.MappingException;
import com.remondis.remap.Properties;
import com.remondis.remap.ReflectionUtil;
import com.remondis.remap.Transformation;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class ReassignTransformation
extends Transformation {
    private static final String REASSIGNING_MSG = "Reassigning %s\n           to %s";

    ReassignTransformation(MappingConfiguration<?, ?> mapping, PropertyDescriptor sourceProperty, PropertyDescriptor destinationProperty) {
        super(mapping, sourceProperty, destinationProperty);
    }

    protected static boolean isEqualTypes(Class<?> sourceType, Class<?> destinationType) {
        return sourceType.equals(destinationType);
    }

    private boolean isReferenceMapping(Class<?> sourceType, Class<?> destinationType) {
        return ReassignTransformation.isEqualTypes(sourceType, destinationType) || ReflectionUtil.isWrapper(sourceType, destinationType) || ReflectionUtil.isWrapper(destinationType, sourceType);
    }

    @Override
    protected void performTransformation(PropertyDescriptor sourceProperty, Object source, PropertyDescriptor destinationProperty, Object destination) throws MappingException {
        Object sourceValue = this.readOrFail(sourceProperty, source);
        MappedResult result = MappedResult.skip();
        if (sourceValue != null) {
            result = this.performValueTransformation(sourceValue, destination);
        }
        if (result.hasValue() || this.mapping.isWriteNull()) {
            this.writeOrFail(destinationProperty, destination, result.getValue());
        }
    }

    @Override
    protected MappedResult performValueTransformation(Object source, Object destination) throws MappingException {
        GenericParameterContext sourceCtx = new GenericParameterContext(this.sourceProperty.getReadMethod());
        GenericParameterContext destinationCtx = new GenericParameterContext(this.destinationProperty.getReadMethod());
        Object destinationValue = this._convert(sourceCtx.getCurrentType(), source, destinationCtx.getCurrentType(), destination, sourceCtx, destinationCtx);
        return MappedResult.value(destinationValue);
    }

    private Object _convert(Class<?> sourceType, Object sourceValue, Class<?> destinationType, Object destination, GenericParameterContext sourceCtx, GenericParameterContext destinationCtx) {
        if (this.hasMapperFor(sourceType, (Class)destinationType)) {
            InternalMapper<?, ?> mapper = this.getMapperFor(sourceType, destinationType);
            return mapper.map(sourceValue, null);
        }
        if (ReassignTransformation.isMap(sourceValue)) {
            return this.convertMap(sourceValue, sourceCtx, destinationCtx);
        }
        if (ReassignTransformation.isCollection(sourceValue)) {
            return this.convertCollection(sourceValue, sourceCtx, destinationCtx);
        }
        return this.convertValueMapOver(sourceType, sourceValue, destinationType, destination);
    }

    private Object convertCollection(Object sourceValue, GenericParameterContext sourceCtx, GenericParameterContext destinationCtx) {
        Class<?> destinationCollectionType = destinationCtx.getCurrentType();
        Collection collection = (Collection)Collection.class.cast(sourceValue);
        Collector collector = ReflectionUtil.getCollector(destinationCollectionType);
        return collection.stream().map(o -> {
            GenericParameterContext newSourceCtx = sourceCtx.goInto(0);
            Class<?> sourceElementType = newSourceCtx.getCurrentType();
            GenericParameterContext newDestCtx = destinationCtx.goInto(0);
            Class<?> destinationElementType = newDestCtx.getCurrentType();
            return this._convert(sourceElementType, o, destinationElementType, null, newSourceCtx, newDestCtx);
        }).collect(collector);
    }

    private Object convertMap(Object sourceValue, GenericParameterContext sourceCtx, GenericParameterContext destinationCtx) {
        GenericParameterContext sourceKeyContext = sourceCtx.goInto(0);
        Class<?> sourceMapKeyType = sourceKeyContext.getCurrentType();
        GenericParameterContext destKeyContext = destinationCtx.goInto(0);
        Class<?> destinationMapKeyType = destKeyContext.getCurrentType();
        GenericParameterContext sourceValueContext = sourceCtx.goInto(1);
        Class<?> sourceMapValueType = sourceValueContext.getCurrentType();
        GenericParameterContext destValueContext = destinationCtx.goInto(1);
        Class<?> destinationMapValueType = destValueContext.getCurrentType();
        Map map = (Map)Map.class.cast(sourceValue);
        return map.entrySet().stream().map(o -> {
            Object key = o.getKey();
            Object value = o.getValue();
            Object mappedKey = this._convert(sourceMapKeyType, key, destinationMapKeyType, null, sourceKeyContext, destKeyContext);
            Object mappedValue = this._convert(sourceMapValueType, value, destinationMapValueType, null, sourceValueContext, destValueContext);
            return new AbstractMap.SimpleEntry<Object, Object>(mappedKey, mappedValue);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    Object convertValue(Class<?> sourceType, Object sourceValue, Class<?> destinationType) {
        if (this.isReferenceMapping(sourceType, destinationType)) {
            return sourceValue;
        }
        InternalMapper<?, ?> delegateMapper = this.getMapperFor(sourceType, destinationType);
        return delegateMapper.map(sourceValue);
    }

    Object convertValueMapOver(Class<?> sourceType, Object sourceValue, Class<?> destinationType, Object destinationValue) {
        if (this.isReferenceMapping(sourceType, destinationType)) {
            return sourceValue;
        }
        InternalMapper<?, ?> delegateMapper = this.getMapperFor(sourceType, destinationType);
        Object destinationValueMapped = this.readOrFail(this.destinationProperty, destinationValue);
        return delegateMapper.map(sourceValue, destinationValueMapped);
    }

    static Class<?> findGenericTypeFromMethod(Method method, int genericParameterIndex) {
        ParameterizedType parameterizedType = (ParameterizedType)method.getGenericReturnType();
        Object type = null;
        while (parameterizedType != null) {
            type = parameterizedType.getActualTypeArguments()[genericParameterIndex];
            if (type instanceof ParameterizedType) {
                parameterizedType = (ParameterizedType)type;
                continue;
            }
            if (type instanceof TypeVariable) {
                type = Object.class;
                parameterizedType = null;
                continue;
            }
            parameterizedType = null;
        }
        return (Class)type;
    }

    static boolean isCollection(Class<?> type) {
        return Collection.class.isAssignableFrom(type);
    }

    static boolean isCollection(Object collection) {
        return collection instanceof Collection;
    }

    @Override
    protected void validateTransformation() throws MappingException {
        GenericParameterContext sourceCtx = new GenericParameterContext(this.getSourceProperty().getReadMethod());
        GenericParameterContext destCtx = new GenericParameterContext(this.getDestinationProperty().getReadMethod());
        this._validateTransformation(sourceCtx, destCtx);
    }

    private void _validateTransformation(GenericParameterContext sourceCtx, GenericParameterContext destCtx) {
        boolean incompatibleCollecion;
        Class<?> sourceType = sourceCtx.getCurrentType();
        Class<?> destinationType = destCtx.getCurrentType();
        boolean bl = incompatibleCollecion = ReassignTransformation.isMap(sourceType) && ReassignTransformation.isCollection(destinationType) || ReassignTransformation.isCollection(sourceType) && ReassignTransformation.isMap(destinationType) || ReassignTransformation.noCollectionOrMap(sourceType) && ReassignTransformation.isCollectionOrMap(destinationType) || ReassignTransformation.isCollectionOrMap(sourceType) && ReassignTransformation.noCollectionOrMap(destinationType);
        if (incompatibleCollecion) {
            throw MappingException.incompatibleCollectionMapping(this.getSourceProperty(), sourceCtx, this.getDestinationProperty(), destCtx);
        }
        if (ReassignTransformation.isMap(sourceType)) {
            GenericParameterContext sourceKeyContext = sourceCtx.goInto(0);
            GenericParameterContext destKeyContext = destCtx.goInto(0);
            GenericParameterContext sourceValueContext = sourceCtx.goInto(1);
            GenericParameterContext destValueContext = destCtx.goInto(1);
            this._validateTransformation(sourceKeyContext, destKeyContext);
            this._validateTransformation(sourceValueContext, destValueContext);
        }
        if (ReassignTransformation.isCollection(sourceType)) {
            GenericParameterContext sourceElemType = sourceCtx.goInto(0);
            GenericParameterContext destElemType = destCtx.goInto(0);
            this._validateTransformation(sourceElemType, destElemType);
        } else {
            this.validateTypeMapping(this.getSourceProperty(), sourceType, this.getDestinationProperty(), destinationType);
        }
    }

    private static boolean noCollectionOrMap(Class<?> type) {
        return !ReassignTransformation.isMap(type) && !ReassignTransformation.isCollection(type);
    }

    private static boolean isCollectionOrMap(Class<?> type) {
        return !ReassignTransformation.noCollectionOrMap(type);
    }

    private void validateTypeMapping(PropertyDescriptor sourceProperty, Class<?> sourceType, PropertyDescriptor destinationProperty, Class<?> destinationType) {
        if (!this.isReferenceMapping(sourceType, destinationType)) {
            this.getMapperFor(sourceType, destinationType);
        }
    }

    private static boolean isMap(Class<?> sourceType) {
        return Map.class.isAssignableFrom(sourceType);
    }

    private static boolean isMap(Object object) {
        return object instanceof Map;
    }

    @Override
    public String toString(boolean detailed) {
        return String.format(REASSIGNING_MSG, Properties.asString(this.sourceProperty, detailed), Properties.asString(this.destinationProperty, detailed));
    }
}

