/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap;

import com.remondis.propertypath.api.PropertyPath;
import com.remondis.remap.Lang;
import com.remondis.remap.MappingConfiguration;
import com.remondis.remap.PropertyPathAndApplyBuilder;
import com.remondis.remap.PropertyPathTransformation;
import com.remondis.remap.ReplaceTransformation;
import com.remondis.remap.TypedPropertyDescriptor;
import java.util.function.Function;

public class ReplaceBuilder<S, D, RD, RS> {
    static final String TRANSFORM = "transform";
    private TypedPropertyDescriptor<RS> sourceProperty;
    private TypedPropertyDescriptor<RD> destProperty;
    private MappingConfiguration<S, D> mapping;

    ReplaceBuilder(TypedPropertyDescriptor<RS> sourceProperty, TypedPropertyDescriptor<RD> destProperty, MappingConfiguration<S, D> mapping) {
        this.sourceProperty = sourceProperty;
        this.destProperty = destProperty;
        this.mapping = mapping;
    }

    public <E extends Exception> MappingConfiguration<S, D> withPropertyPath(PropertyPath<RD, RS, E> propertyPath) {
        Lang.denyNull("propertyPath", propertyPath);
        PropertyPathTransformation replace = new PropertyPathTransformation(this.mapping, this.sourceProperty.property, this.destProperty.property, propertyPath);
        this.mapping.addMapping(this.sourceProperty.property, this.destProperty.property, replace);
        return this.mapping;
    }

    public <X, E extends Exception> PropertyPathAndApplyBuilder<S, D, RD, X, RS, E> withPropertyPathAnd(PropertyPath<X, RS, E> propertyPath) {
        Lang.denyNull("propertyPath", propertyPath);
        return new PropertyPathAndApplyBuilder<S, D, RD, X, RS, E>(this.mapping, this.sourceProperty, this.destProperty, propertyPath);
    }

    public MappingConfiguration<S, D> with(Function<RS, RD> transformation) {
        Lang.denyNull("tranformation", transformation);
        ReplaceTransformation<RS, RD> replace = new ReplaceTransformation<RS, RD>(this.mapping, this.sourceProperty.property, this.destProperty.property, transformation, false);
        this.mapping.addMapping(this.sourceProperty.property, this.destProperty.property, replace);
        return this.mapping;
    }

    public MappingConfiguration<S, D> withSkipWhenNull(Function<RS, RD> transformation) {
        Lang.denyNull("tranformation", transformation);
        ReplaceTransformation<RS, RD> replace = new ReplaceTransformation<RS, RD>(this.mapping, this.sourceProperty.property, this.destProperty.property, transformation, true);
        this.mapping.addMapping(this.sourceProperty.property, this.destProperty.property, replace);
        return this.mapping;
    }
}

