/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap;

import com.remondis.propertypath.api.PropertyPath;
import com.remondis.remap.Lang;
import com.remondis.remap.MappingConfiguration;
import com.remondis.remap.PropertyPathAndApplyCollectionBuilder;
import com.remondis.remap.PropertyPathCollectionTransformation;
import com.remondis.remap.ReplaceCollectionTransformation;
import com.remondis.remap.TypedPropertyDescriptor;
import java.util.Collection;
import java.util.function.Function;

public class ReplaceCollectionBuilder<S, D, RD, RS> {
    static final String TRANSFORM = "transform";
    private TypedPropertyDescriptor<Collection<RS>> sourceProperty;
    private TypedPropertyDescriptor<Collection<RD>> destProperty;
    private MappingConfiguration<S, D> mapping;

    ReplaceCollectionBuilder(TypedPropertyDescriptor<Collection<RS>> sourceProperty, TypedPropertyDescriptor<Collection<RD>> destProperty, MappingConfiguration<S, D> mapping) {
        this.sourceProperty = sourceProperty;
        this.destProperty = destProperty;
        this.mapping = mapping;
    }

    public <E extends Exception> MappingConfiguration<S, D> withPropertyPath(PropertyPath<RD, RS, E> propertyPath) {
        Lang.denyNull("propertyPath", propertyPath);
        PropertyPathCollectionTransformation replace = new PropertyPathCollectionTransformation(this.mapping, this.sourceProperty.property, this.destProperty.property, propertyPath);
        this.mapping.addMapping(this.sourceProperty.property, this.destProperty.property, replace);
        return this.mapping;
    }

    public <X, E extends Exception> PropertyPathAndApplyCollectionBuilder<S, D, RD, X, RS, E> withPropertyPathAnd(PropertyPath<X, RS, E> propertyPath) {
        Lang.denyNull("propertyPath", propertyPath);
        return new PropertyPathAndApplyCollectionBuilder<S, D, RD, X, RS, E>(this.mapping, this.sourceProperty, this.destProperty, propertyPath);
    }

    public MappingConfiguration<S, D> with(Function<RS, RD> transformation) {
        Lang.denyNull("tranformation", transformation);
        ReplaceCollectionTransformation<RS, RD> replace = new ReplaceCollectionTransformation<RS, RD>(this.mapping, this.sourceProperty.property, this.destProperty.property, transformation, false);
        this.mapping.addMapping(this.sourceProperty.property, this.destProperty.property, replace);
        return this.mapping;
    }

    public MappingConfiguration<S, D> withSkipWhenNull(Function<RS, RD> transformation) {
        Lang.denyNull("tranformation", transformation);
        ReplaceCollectionTransformation<RS, RD> replace = new ReplaceCollectionTransformation<RS, RD>(this.mapping, this.sourceProperty.property, this.destProperty.property, transformation, true);
        this.mapping.addMapping(this.sourceProperty.property, this.destProperty.property, replace);
        return this.mapping;
    }
}

