/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap;

import com.remondis.remap.Lang;
import com.remondis.remap.MappingConfiguration;
import com.remondis.remap.SetSupplierTransformation;
import com.remondis.remap.SetTransformation;
import com.remondis.remap.SetValueTransformation;
import com.remondis.remap.TypedPropertyDescriptor;
import java.util.function.Function;
import java.util.function.Supplier;

public class SetBuilder<S, D, RD> {
    static final String TRANSFORM = "transform";
    private TypedPropertyDescriptor<RD> destProperty;
    private MappingConfiguration<S, D> mapping;

    SetBuilder(TypedPropertyDescriptor<RD> destProperty, MappingConfiguration<S, D> mapping) {
        this.destProperty = destProperty;
        this.mapping = mapping;
    }

    public MappingConfiguration<S, D> with(Function<S, RD> valueSupplier) {
        Lang.denyNull("valueSupplier", valueSupplier);
        SetTransformation<S, D, RD> setTransformation = new SetTransformation<S, D, RD>(this.mapping, this.destProperty.property, valueSupplier);
        this.mapping.addDestinationMapping(this.destProperty.property, setTransformation);
        return this.mapping;
    }

    public MappingConfiguration<S, D> with(Supplier<RD> valueSupplier) {
        Lang.denyNull("valueSupplier", valueSupplier);
        SetSupplierTransformation<S, D, RD> setTransformation = new SetSupplierTransformation<S, D, RD>(this.mapping, this.destProperty.property, valueSupplier);
        this.mapping.addDestinationMapping(this.destProperty.property, setTransformation);
        return this.mapping;
    }

    public MappingConfiguration<S, D> with(RD value) {
        Lang.denyNull("value", value);
        SetValueTransformation<S, D, RD> setTransformation = new SetValueTransformation<S, D, RD>(this.mapping, this.destProperty.property, value);
        this.mapping.addDestinationMapping(this.destProperty.property, setTransformation);
        return this.mapping;
    }
}

