/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap;

import com.remondis.remap.InternalMapper;
import com.remondis.remap.Lang;
import com.remondis.remap.MappedResult;
import com.remondis.remap.MappingConfiguration;
import com.remondis.remap.MappingException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;

abstract class Transformation {
    protected PropertyDescriptor sourceProperty;
    protected PropertyDescriptor destinationProperty;
    protected MappingConfiguration<?, ?> mapping;

    Transformation(MappingConfiguration<?, ?> mapping, PropertyDescriptor sourceProperty, PropertyDescriptor destinationProperty) {
        Lang.denyNull("mapping", mapping);
        this.mapping = mapping;
        this.sourceProperty = sourceProperty;
        this.destinationProperty = destinationProperty;
    }

    public String getDestinationPropertyName() {
        return Objects.isNull(this.destinationProperty) ? null : this.destinationProperty.getName();
    }

    public String getSourcePropertyName() {
        return Objects.isNull(this.sourceProperty) ? null : this.sourceProperty.getName();
    }

    protected Class<?> getDestinationType() {
        return this.destinationProperty.getPropertyType();
    }

    protected Class<?> getSourceType() {
        return this.sourceProperty.getPropertyType();
    }

    protected Object readOrFail(PropertyDescriptor property, Object source) {
        try {
            Method readMethod = property.getReadMethod();
            readMethod.setAccessible(true);
            return readMethod.invoke(source, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw MappingException.invocationTarget(property, e);
        }
        catch (Exception e) {
            throw MappingException.invocationFailed(property, e);
        }
    }

    protected void writeOrFail(PropertyDescriptor property, Object source, Object value) {
        try {
            Method writeMethod = property.getWriteMethod();
            writeMethod.setAccessible(true);
            writeMethod.invoke(source, value);
        }
        catch (InvocationTargetException e) {
            throw MappingException.invocationTarget(property, e);
        }
        catch (Exception e) {
            throw MappingException.invocationFailed(property, e);
        }
    }

    public void performTransformation(Object source, Object destination) throws MappingException {
        this.performTransformation(this.sourceProperty, source, this.destinationProperty, destination);
    }

    protected abstract void performTransformation(PropertyDescriptor var1, Object var2, PropertyDescriptor var3, Object var4) throws MappingException;

    protected abstract MappedResult performValueTransformation(Object var1, Object var2) throws MappingException;

    protected abstract void validateTransformation() throws MappingException;

    <S, T> InternalMapper<S, T> getMapperFor(Class<S> sourceType, Class<T> destinationType) {
        return this.mapping.getMapperFor(this.getSourceProperty(), sourceType, this.getDestinationProperty(), destinationType);
    }

    public <S, T> boolean hasMapperFor(Class<S> sourceType, Class<T> destinationType) {
        return this.mapping.hasMapperFor(sourceType, destinationType);
    }

    PropertyDescriptor getSourceProperty() {
        return this.sourceProperty;
    }

    PropertyDescriptor getDestinationProperty() {
        return this.destinationProperty;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.destinationProperty == null ? 0 : this.destinationProperty.hashCode());
        result = 31 * result + (this.sourceProperty == null ? 0 : this.sourceProperty.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Transformation other = (Transformation)obj;
        if (this.destinationProperty == null ? other.destinationProperty != null : !this.destinationProperty.equals(other.destinationProperty)) {
            return false;
        }
        return !(this.sourceProperty == null ? other.sourceProperty != null : !this.sourceProperty.equals(other.sourceProperty));
    }

    public String toString() {
        return this.toString(false);
    }

    public abstract String toString(boolean var1);
}

