/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap;

import com.remondis.remap.InternalMapper;
import com.remondis.remap.Lang;
import com.remondis.remap.Projection;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class TypeMapping<S, D>
implements InternalMapper<S, D> {
    private Class<S> source;
    private Class<D> destination;
    private BiFunction<S, Optional<D>, D> conversionFunction;

    public static <S> TypeMappingBuilder<S> from(Class<S> source) {
        Lang.denyNull("source", source);
        return new TypeMappingBuilder<S>(source);
    }

    TypeMapping(Class<S> source, Class<D> destination, BiFunction<S, Optional<D>, D> conversionFunction) {
        this.source = source;
        this.destination = destination;
        this.conversionFunction = conversionFunction;
    }

    TypeMapping(Class<S> source, Class<D> destination, final Function<S, D> conversionFunction) {
        this.source = source;
        this.destination = destination;
        this.conversionFunction = new BiFunction<S, Optional<D>, D>(){

            @Override
            public D apply(S s, Optional<D> d) {
                return conversionFunction.apply(s);
            }
        };
    }

    @Override
    public D map(S source, D destination) {
        return this.conversionFunction.apply(source, Optional.ofNullable(destination));
    }

    @Override
    public D map(S source) {
        return this.conversionFunction.apply(source, Optional.empty());
    }

    @Override
    public Projection<S, D> getProjection() {
        return new Projection<S, D>(this.source, this.destination);
    }

    public static class TypeMappingFunctionBuilder<S, D> {
        private Class<S> source;
        private Class<D> destination;

        TypeMappingFunctionBuilder(Class<S> source, Class<D> destination) {
            this.source = source;
            this.destination = destination;
        }

        public TypeMapping<S, D> applying(Function<S, D> conversionFunction) {
            Lang.denyNull("conversionFunction", conversionFunction);
            return new TypeMapping<S, D>(this.source, this.destination, conversionFunction);
        }
    }

    public static class TypeMappingBuilder<S> {
        private Class<S> source;

        public TypeMappingBuilder(Class<S> source) {
            this.source = source;
        }

        public <D> TypeMappingFunctionBuilder<S, D> to(Class<D> destination) {
            Lang.denyNull("destination", destination);
            return new TypeMappingFunctionBuilder<S, D>(this.source, destination);
        }
    }
}

