/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap;

import com.remondis.remap.AssertVerification;
import com.remondis.remap.FieldSelector;
import com.remondis.remap.Lang;
import com.remondis.remap.MapTransformation;
import com.remondis.remap.Mapper;
import com.remondis.remap.MappingConfiguration;
import com.remondis.remap.OmitTransformation;
import com.remondis.remap.ReassignAssertBuilder;
import com.remondis.remap.ReplaceAssertBuilder;
import com.remondis.remap.ReplaceCollectionAssertBuilder;
import com.remondis.remap.RestructureAssertBuilder;
import com.remondis.remap.SetAssertBuilder;
import com.remondis.remap.SkipWhenNullTransformation;
import com.remondis.remap.Target;
import com.remondis.remap.Transformation;
import com.remondis.remap.TypedPropertyDescriptor;
import com.remondis.remap.TypedSelector;
import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AssertConfiguration<S, D> {
    static final String DIFFERENT_NULL_STRATEGY = "The replace transformation specified by the mapper has a different null value strategy than the expected transformation:\n";
    static final String UNEXPECTED_EXCEPTION = "Function threw an unexpected exception for transformation:\n";
    static final String NOT_NULL_SAFE = "The specified transformation function is not null-safe for operation:\n";
    static final String UNEXPECTED_TRANSFORMATION = "The following unexpected transformation were specified on the mapping:\n";
    static final String EXPECTED_TRANSFORMATION = "The following expected transformation were not specified on the mapping:\n";
    static final String TRANSFORMATION_ALREADY_ADDED = "The specified transformation was already added as an assertion";
    private Mapper<S, D> mapper;
    private Set<Transformation> assertedTransformations;
    private boolean omitOthersSource = false;
    private boolean omitOthersDestination = false;
    private Object expectN;
    private boolean expectNoImplicitMappings;
    private List<AssertVerification> verificaions;
    private boolean expectWriteNullIfSourceIsNull = false;
    private boolean expectFluentSettersAllowed = false;

    AssertConfiguration(Mapper<S, D> mapper) {
        Lang.denyNull("mapper", mapper);
        this.mapper = mapper;
        this.assertedTransformations = new HashSet<Transformation>();
        this.verificaions = new LinkedList<AssertVerification>();
    }

    public <RS> ReassignAssertBuilder<S, D, RS> expectReassign(FieldSelector<S> sourceSelector) {
        Lang.denyNull("sourceSelector", sourceSelector);
        PropertyDescriptor sourceProperty = MappingConfiguration.getPropertyFromFieldSelector(Target.SOURCE, "assign", this.getMapping().getSource(), sourceSelector, this.mapper.getMapping().isFluentSettersAllowed());
        ReassignAssertBuilder reassignBuilder = new ReassignAssertBuilder(sourceProperty, this.getMapping().getDestination(), this);
        return reassignBuilder;
    }

    public <RD, RS> ReplaceAssertBuilder<S, D, RD, RS> expectReplace(TypedSelector<RS, S> sourceSelector, TypedSelector<RD, D> destinationSelector) {
        Lang.denyNull("sourceSelector", sourceSelector);
        Lang.denyNull("destinationSelector", destinationSelector);
        TypedPropertyDescriptor<RS> sourceProperty = MappingConfiguration.getTypedPropertyFromFieldSelector(Target.SOURCE, "transform", this.getMapping().getSource(), sourceSelector, this.mapper.getMapping().isFluentSettersAllowed());
        TypedPropertyDescriptor<RD> destProperty = MappingConfiguration.getTypedPropertyFromFieldSelector(Target.DESTINATION, "transform", this.getMapping().getDestination(), destinationSelector, this.mapper.getMapping().isFluentSettersAllowed());
        ReplaceAssertBuilder builder = new ReplaceAssertBuilder(sourceProperty, destProperty, this);
        return builder;
    }

    public <RD> SetAssertBuilder<S, D, RD> expectSet(TypedSelector<RD, D> destinationSelector) {
        Lang.denyNull("destinationSelector", destinationSelector);
        TypedPropertyDescriptor<RD> destProperty = MappingConfiguration.getTypedPropertyFromFieldSelector(Target.DESTINATION, "transform", this.getMapping().getDestination(), destinationSelector, this.mapper.getMapping().isFluentSettersAllowed());
        SetAssertBuilder builder = new SetAssertBuilder(destProperty, this);
        return builder;
    }

    public <RD> RestructureAssertBuilder<S, D, RD> expectRestructure(TypedSelector<RD, D> destinationSelector) {
        Lang.denyNull("destinationSelector", destinationSelector);
        TypedPropertyDescriptor<RD> destProperty = MappingConfiguration.getTypedPropertyFromFieldSelector(Target.DESTINATION, "transform", this.getMapping().getDestination(), destinationSelector, this.mapper.getMapping().isFluentSettersAllowed());
        RestructureAssertBuilder builder = new RestructureAssertBuilder(destProperty, this);
        return builder;
    }

    public <RD, RS> ReplaceCollectionAssertBuilder<S, D, RD, RS> expectReplaceCollection(TypedSelector<Collection<RS>, S> sourceSelector, TypedSelector<Collection<RD>, D> destinationSelector) {
        Lang.denyNull("sourceSelector", sourceSelector);
        Lang.denyNull("destinationSelector", destinationSelector);
        TypedPropertyDescriptor<Collection<RS>> sourceProperty = MappingConfiguration.getTypedPropertyFromFieldSelector(Target.SOURCE, "transform", this.getMapping().getSource(), sourceSelector, this.mapper.getMapping().isFluentSettersAllowed());
        TypedPropertyDescriptor<Collection<RD>> destProperty = MappingConfiguration.getTypedPropertyFromFieldSelector(Target.DESTINATION, "transform", this.getMapping().getDestination(), destinationSelector, this.mapper.getMapping().isFluentSettersAllowed());
        ReplaceCollectionAssertBuilder builder = new ReplaceCollectionAssertBuilder(sourceProperty, destProperty, this);
        return builder;
    }

    private void _add(Transformation transformation) {
        if (this.assertedTransformations.contains(transformation)) {
            throw new AssertionError((Object)TRANSFORMATION_ALREADY_ADDED);
        }
        this.assertedTransformations.add(transformation);
    }

    public AssertConfiguration<S, D> expectOmitInSource(FieldSelector<S> sourceSelector) {
        Lang.denyNull("sourceSelector", sourceSelector);
        PropertyDescriptor propertyDescriptor = MappingConfiguration.getPropertyFromFieldSelector(Target.SOURCE, "omit in source", this.getMapping().getSource(), sourceSelector, this.mapper.getMapping().isFluentSettersAllowed());
        OmitTransformation omitSource = OmitTransformation.omitSource(this.getMapping(), propertyDescriptor);
        this._add(omitSource);
        return this;
    }

    public AssertConfiguration<S, D> expectNoImplicitMappings() {
        this.expectNoImplicitMappings = true;
        return this;
    }

    public AssertConfiguration<S, D> expectFluentSettersAllowed() {
        this.expectFluentSettersAllowed = true;
        return this;
    }

    public AssertConfiguration<S, D> expectToWriteNullIfSourceIsNull() {
        this.expectWriteNullIfSourceIsNull = true;
        return this;
    }

    public AssertConfiguration<S, D> expectOmitInDestination(FieldSelector<D> destinationSelector) {
        Lang.denyNull("destinationSelector", destinationSelector);
        PropertyDescriptor propertyDescriptor = MappingConfiguration.getPropertyFromFieldSelector(Target.DESTINATION, "omit in destination", this.getMapping().getDestination(), destinationSelector, this.mapper.getMapping().isFluentSettersAllowed());
        OmitTransformation omitDestination = OmitTransformation.omitDestination(this.getMapping(), propertyDescriptor);
        this._add(omitDestination);
        return this;
    }

    public AssertConfiguration<S, D> expectOthersToBeOmitted() {
        this.expectOtherSourceFieldsToBeOmitted();
        this.expectOtherDestinationFieldsToBeOmitted();
        return this;
    }

    public AssertConfiguration<S, D> expectOtherSourceFieldsToBeOmitted() {
        this.omitOthersSource = true;
        return this;
    }

    public AssertConfiguration<S, D> expectOtherDestinationFieldsToBeOmitted() {
        this.omitOthersDestination = true;
        return this;
    }

    public void ensure() throws AssertionError {
        this.checkImplicitMappingStrategy();
        this.checkNullHandling();
        this.checkFluentSetters();
        this.checkReplaceTransformations();
        this.checkVerifications();
        this.checkTransformations();
        this.checkReplaceFunctions();
    }

    private void checkVerifications() {
        this.verificaions.stream().forEach(AssertVerification::verify);
    }

    private void checkImplicitMappingStrategy() {
        if (!this.mapper.getMapping().isNoImplicitMappings() && this.expectNoImplicitMappings) {
            throw new AssertionError((Object)"The mapper was expected to create no implicit mappings but the actual mapper does.");
        }
        if (this.mapper.getMapping().isNoImplicitMappings() && !this.expectNoImplicitMappings) {
            throw new AssertionError((Object)"The mapper was expected to create implicit mappings but the actual mapper does not.");
        }
    }

    private void checkNullHandling() {
        if (!this.mapper.getMapping().isWriteNull() && this.expectWriteNullIfSourceIsNull) {
            throw new AssertionError((Object)"The mapper was expected to write null values if the source value is null, but the current mapper is configured to skip mappings if source value is null.");
        }
        if (this.mapper.getMapping().isWriteNull() && !this.expectWriteNullIfSourceIsNull) {
            throw new AssertionError((Object)"The mapper was expected to skip mapping if the source value is null, but the current mapper is configured to write null if source value is null.");
        }
    }

    private void checkFluentSetters() {
        if (!this.mapper.getMapping().isFluentSettersAllowed() && this.expectFluentSettersAllowed) {
            throw new AssertionError((Object)"The mapper was expected to support fluent setter methods, but the current mapper is configured to only handle Java Bean compliant setter methods.");
        }
        if (this.mapper.getMapping().isFluentSettersAllowed() && !this.expectFluentSettersAllowed) {
            throw new AssertionError((Object)"The mapper was expected to only support Java Bean compliant setter methods, but the current mapper is configured to also support fluent setter methods.");
        }
    }

    private void checkReplaceFunctions() {
        Set<Transformation> mappings = this.mapper.getMapping().getMappings();
        mappings.stream().filter(t -> t instanceof SkipWhenNullTransformation).map(t -> (SkipWhenNullTransformation)t).forEach(r -> {
            Function transformation = r.getTransformation();
            if (!r.isSkipWhenNull()) {
                AssertConfiguration.assertionErrorIfNullCheckFails(r, transformation);
            }
        });
    }

    private static <S, D> void assertionErrorIfNullCheckFails(Transformation r, Function<S, D> transformation) throws AssertionError {
        try {
            transformation.apply(null);
        }
        catch (NullPointerException t) {
            throw new AssertionError(NOT_NULL_SAFE + r.toString(), t);
        }
        catch (Throwable t) {
            throw new AssertionError(UNEXPECTED_EXCEPTION + r.toString(), t);
        }
    }

    private void checkReplaceTransformations() {
        Set<Transformation> mappings = this.mapper.getMapping().getMappings();
        mappings.stream().filter(t -> t instanceof SkipWhenNullTransformation).map(t -> (SkipWhenNullTransformation)t).forEach(replace -> {
            Optional<SkipWhenNullTransformation> sameTransformation = this.assertedTransformations().stream().filter(t -> t instanceof SkipWhenNullTransformation).map(t -> (SkipWhenNullTransformation)t).filter(r -> r.getSourceProperty().equals(replace.getSourceProperty())).filter(r -> r.getDestinationProperty().equals(replace.getDestinationProperty())).findFirst();
            if (sameTransformation.isPresent()) {
                SkipWhenNullTransformation assertedReplaceTransformation = sameTransformation.get();
                if (replace.isSkipWhenNull() != assertedReplaceTransformation.isSkipWhenNull()) {
                    throw new AssertionError((Object)(DIFFERENT_NULL_STRATEGY + replace.toString()));
                }
            }
        });
    }

    private void checkTransformations() {
        Set<Transformation> mappings = this.getMapping().getMappings();
        Set<Transformation> assertedTransformations = this.assertedTransformations();
        mappings.removeAll(assertedTransformations);
        assertedTransformations.removeAll(this.getMapping().getMappings());
        if (!assertedTransformations.isEmpty()) {
            throw new AssertionError((Object)(EXPECTED_TRANSFORMATION + this.listCollection(assertedTransformations)));
        }
        if (!mappings.isEmpty()) {
            Set<Transformation> unexpectedTransformations;
            Stream<Object> tranformationStream = mappings.stream();
            if (this.omitOthersDestination) {
                tranformationStream = tranformationStream.filter(t -> {
                    if (t instanceof OmitTransformation) {
                        OmitTransformation omitTransformation = (OmitTransformation)t;
                        return !omitTransformation.isOmitInDestination();
                    }
                    return true;
                });
            }
            if (this.omitOthersSource) {
                tranformationStream = tranformationStream.filter(t -> {
                    if (t instanceof OmitTransformation) {
                        OmitTransformation omitTransformation = (OmitTransformation)t;
                        return !omitTransformation.isOmitInSource();
                    }
                    return true;
                });
            }
            if (!(unexpectedTransformations = (tranformationStream = tranformationStream.filter(t -> !(t instanceof MapTransformation))).collect(Collectors.toSet())).isEmpty()) {
                throw new AssertionError((Object)(UNEXPECTED_TRANSFORMATION + this.listCollection(unexpectedTransformations)));
            }
        }
    }

    private String listCollection(Set<Transformation> transformations) {
        StringBuilder b = new StringBuilder();
        transformations.stream().forEach(t -> b.append("- " + t.toString()).append("\n"));
        return b.toString();
    }

    private Set<Transformation> assertedTransformations() {
        return new HashSet<Transformation>(this.assertedTransformations);
    }

    void addAssertion(Transformation transformation) {
        this._add(transformation);
    }

    MappingConfiguration<S, D> getMapping() {
        return this.mapper.getMapping();
    }

    void addVerification(AssertVerification verification) {
        Lang.denyNull("verification", verification);
        this.verificaions.add(verification);
    }
}

