/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap;

import com.remondis.remap.ClassHierarchyIterator;
import com.remondis.remap.MappingException;
import com.remondis.remap.ReflectionUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class InvocationSensor<T> {
    private T proxyObject;
    private List<String> propertyNames = new LinkedList<String>();

    public InvocationSensor(Class<T> superType) {
        ClassLoader classLoader = Objects.isNull(superType) || Objects.isNull(superType.getClassLoader()) ? ClassLoader.getSystemClassLoader() : superType.getClassLoader();
        Object po = null;
        try {
            po = new ByteBuddy().subclass(superType).method(this.isDeclaredByClassHierarchy(superType)).intercept((Implementation)MethodDelegation.to((Object)this)).make().load(classLoader, (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new MappingException(String.format("Error while creating proxy for class '%s'", superType.getCanonicalName()), ex);
        }
        this.proxyObject = po;
    }

    private ElementMatcher.Junction<MethodDescription> isDeclaredByClassHierarchy(Class<T> type) {
        ClassHierarchyIterator classHierarchyIterator = new ClassHierarchyIterator(type);
        ElementMatcher.Junction methodDescriptionJunction = null;
        while (classHierarchyIterator.hasNext()) {
            Object next = classHierarchyIterator.next();
            if (Objects.isNull(methodDescriptionJunction)) {
                methodDescriptionJunction = ElementMatchers.isDeclaredBy((Class)next);
                continue;
            }
            methodDescriptionJunction = methodDescriptionJunction.or((ElementMatcher)ElementMatchers.isDeclaredBy((Class)next));
        }
        return methodDescriptionJunction;
    }

    @RuntimeType
    public Object intercept(@Origin Method method, @AllArguments Object[] args) throws Exception {
        if (ReflectionUtil.isGetter(method)) {
            this.denyNoReturnType(method);
            String propertyName = ReflectionUtil.toPropertyName(method);
            this.propertyNames.add(propertyName);
            return InvocationSensor.nullOrDefaultValue(method.getReturnType());
        }
        if (InvocationSensor.isObjectMethod(method)) {
            return ReflectionUtil.invokeMethodProxySafe(method, this, args);
        }
        return InvocationSensor.nullOrDefaultValue(method.getReturnType());
    }

    T getSensor() {
        return this.proxyObject;
    }

    List<String> getTrackedPropertyNames() {
        return Collections.unmodifiableList(this.propertyNames);
    }

    boolean hasTrackedProperties() {
        return !this.propertyNames.isEmpty();
    }

    void reset() {
        this.propertyNames.clear();
    }

    private void denyNoReturnType(Method method) {
        if (!ReflectionUtil.hasReturnType(method)) {
            throw MappingException.noReturnTypeOnGetter(method);
        }
    }

    private static Object nullOrDefaultValue(Class<?> returnType) {
        if (returnType.isPrimitive()) {
            return ReflectionUtil.defaultValue(returnType);
        }
        return null;
    }

    private static boolean isObjectMethod(Method method) {
        return method.getDeclaringClass() == Object.class;
    }
}

