/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap;

import com.remondis.remap.MappingConfiguration;
import com.remondis.remap.MappingModel;
import com.remondis.remap.ReflectionUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Mapper<S, D> {
    private MappingConfiguration<S, D> mapping;

    Mapper(MappingConfiguration<S, D> mapping) {
        this.mapping = mapping;
    }

    MappingConfiguration<S, D> getMapping() {
        return this.mapping;
    }

    public D map(S source) {
        return this.mapping.map(source);
    }

    public D map(S source, D destination) {
        return this.mapping.map(source, destination);
    }

    public Collection<D> map(Collection<? extends S> source) {
        return this._mapCollection(source);
    }

    public List<D> map(List<? extends S> source) {
        return (List)this._mapCollection(source);
    }

    public Set<D> map(Set<? extends S> source) {
        return (Set)this._mapCollection(source);
    }

    public List<D> map(Iterable<? extends S> iterable) {
        Stream<S> stream = StreamSupport.stream(iterable.spliterator(), false);
        return stream.map(this::map).collect(Collectors.toList());
    }

    public D mapOptional(S source) {
        return this.mapOrDefault(source, null);
    }

    public D mapOrDefault(S source, D defaultValue) {
        if (Objects.isNull(source)) {
            return defaultValue;
        }
        return this.mapping.map(source);
    }

    private Collection<D> _mapCollection(Collection<? extends S> source) {
        return (Collection)source.stream().map(this::map).collect(ReflectionUtil.getCollector(source));
    }

    public String toString() {
        return this.mapping.toString();
    }

    public MappingModel<S, D> getMappingModel() {
        return new MappingModel<S, D>(this.getMapping());
    }
}

