/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap;

import com.remondis.remap.FieldSelector;
import com.remondis.remap.InternalMapper;
import com.remondis.remap.MappedResult;
import com.remondis.remap.Mapper;
import com.remondis.remap.MapperAdapter;
import com.remondis.remap.MappingConfiguration;
import com.remondis.remap.OmitTransformation;
import com.remondis.remap.ReassignTransformation;
import com.remondis.remap.RestructureTransformation;
import com.remondis.remap.SetTransformation;
import com.remondis.remap.Target;
import com.remondis.remap.Transformation;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class MappingModel<S, D> {
    private MappingConfiguration<S, D> mapping;

    MappingModel(MappingConfiguration<S, D> mapping) {
        this.mapping = mapping;
    }

    public TransformationSearchResult findMappingBySource(Predicate<String> sourcePropertySelector) {
        return this.findMapping(sourcePropertySelector, null);
    }

    public TransformationSearchResult findMappingByDestination(Predicate<String> destinationPropertySelector) {
        List<Transformation> transformations = this.mapping.getMappings().stream().filter(this.andOnDemand(null, destinationPropertySelector)).collect(Collectors.toList());
        return new TransformationSearchResult(transformations);
    }

    public TransformationSearchResult findMappingBySource(FieldSelector<S> sourceSelector) {
        return this.findMapping(sourceSelector, null);
    }

    public TransformationSearchResult findMappingByDestination(FieldSelector<D> destinationSelector) {
        return this.findMapping(null, destinationSelector);
    }

    public TransformationSearchResult findMapping(FieldSelector<S> sourceSelector, FieldSelector<D> destinationSelector) {
        FeatureDescriptor sourceProperty = null;
        PropertyDescriptor destinationProperty = null;
        if (Objects.nonNull(sourceSelector)) {
            sourceProperty = MappingConfiguration.getPropertyFromFieldSelector(Target.SOURCE, "findMapping", this.mapping.getSource(), sourceSelector, this.mapping.isFluentSettersAllowed());
        }
        if (Objects.nonNull(destinationSelector)) {
            destinationProperty = MappingConfiguration.getPropertyFromFieldSelector(Target.DESTINATION, "findMapping", this.mapping.getDestination(), destinationSelector, this.mapping.isFluentSettersAllowed());
        }
        Predicate<String> sourcePredicate = Objects.isNull(sourceProperty) ? null : MappingModel.nameEqualsPredicate(sourceProperty.getName());
        Predicate<String> destinationPredicate = Objects.isNull(destinationProperty) ? null : MappingModel.nameEqualsPredicate(destinationProperty.getName());
        return this.findMapping(sourcePredicate, destinationPredicate);
    }

    public TransformationSearchResult findMapping(Predicate<String> sourcePropertySelector, Predicate<String> destinationPropertySelector) {
        List<Transformation> transformations = this.mapping.getMappings().stream().filter(this.andOnDemand(sourcePropertySelector, destinationPropertySelector)).collect(Collectors.toList());
        TransformationSearchResult candidates = new TransformationSearchResult(transformations);
        boolean allMatch = transformations.stream().allMatch(t -> t instanceof OmitTransformation);
        if (allMatch) {
            return this.mapping.getMappings().stream().filter(t -> t instanceof RestructureTransformation).map(t -> (RestructureTransformation)t).map(rT -> rT.getRestructureMapper().getMappingModel().findMapping(sourcePropertySelector, destinationPropertySelector)).map(tsr -> tsr.getTransformations()).reduce((list1, list2) -> {
                list1.addAll(list2);
                return list1;
            }).map(x$0 -> new TransformationSearchResult((List<Transformation>)x$0)).orElse(candidates);
        }
        return candidates;
    }

    private Predicate<Transformation> andOnDemand(Predicate<String> sourcePropertySelector, Predicate<String> destinationPropertySelector) {
        Predicate<Transformation> sourcePredicate = Objects.isNull(sourcePropertySelector) ? null : this.toSourcePredicate(sourcePropertySelector);
        Predicate<Transformation> destPredicate = Objects.isNull(destinationPropertySelector) ? null : this.toDestPredicate(destinationPropertySelector);
        Optional<Predicate> reduce = Arrays.asList(sourcePredicate, destPredicate).stream().filter(Objects::nonNull).reduce(Predicate::and);
        return reduce.orElse(p -> false);
    }

    public static Predicate<String> nameEqualsPredicate(String sourceFieldName) {
        return s -> sourceFieldName.equals(s);
    }

    public static Predicate<String> nameEqualsPredicateIgnoreCase(String sourceFieldName) {
        return s -> sourceFieldName.equalsIgnoreCase((String)s);
    }

    private Predicate<Transformation> toPredicate(Predicate<String> propertyNamePredicate, Function<Transformation, PropertyDescriptor> pdExtractor) {
        Objects.requireNonNull(propertyNamePredicate, "predicate must not be null!");
        return t -> propertyNamePredicate.test(((PropertyDescriptor)pdExtractor.apply((Transformation)t)).getName());
    }

    private Predicate<Transformation> toSourcePredicate(Predicate<String> sourcePropertySelector) {
        Function<Transformation, PropertyDescriptor> pdExtractor = Transformation::getSourceProperty;
        return this.hasPropertyDescriptor(pdExtractor).and(this.toPredicate(sourcePropertySelector, pdExtractor));
    }

    private Predicate<Transformation> toDestPredicate(Predicate<String> destinationPropertySelector) {
        Function<Transformation, PropertyDescriptor> pdExtractor = Transformation::getDestinationProperty;
        return this.hasPropertyDescriptor(pdExtractor).and(this.toPredicate(destinationPropertySelector, pdExtractor));
    }

    private Predicate<Transformation> hasPropertyDescriptor(Function<Transformation, PropertyDescriptor> pdExtractor) {
        return t -> Objects.nonNull(pdExtractor.apply((Transformation)t));
    }

    public String toString() {
        return "MappingModel [mapping=" + this.mapping + "]";
    }

    public class TransformationSearchResult
    implements Iterable<TransformationSearchResult> {
        private List<Transformation> transformations;

        TransformationSearchResult(List<Transformation> transformations) {
            this.transformations = transformations;
        }

        List<Transformation> getTransformations() {
            return this.transformations;
        }

        @Override
        public Iterator<TransformationSearchResult> iterator() {
            return this.transformations.stream().map(transformation -> new TransformationSearchResult(Arrays.asList(transformation))).collect(Collectors.toList()).iterator();
        }

        public boolean hasResult() {
            return !this.transformations.isEmpty();
        }

        public boolean hasSingleResult() {
            return this.hasResult() && this.transformations.size() == 1;
        }

        public boolean hasMultipleResults() {
            return this.hasResult() && this.transformations.size() > 1;
        }

        public boolean isValueTransformation() {
            return !(this.getSingleMatch() instanceof RestructureTransformation) && !(this.getSingleMatch() instanceof SetTransformation);
        }

        public boolean isObjectTransformation() {
            return !this.isValueTransformation();
        }

        public boolean isDelegatingTransformation() {
            return this.getSingleMatch() instanceof ReassignTransformation;
        }

        public boolean hasMapperFor(Class<?> sourceType, Class<?> targetType) {
            try {
                this.getMapperFor(sourceType, targetType);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public Mapper<?, ?> getMapperFor(Class<?> sourceType, Class<?> destinationType) {
            InternalMapper<?, ?> internalMapper = this.getSingleMatch().getMapperFor(sourceType, destinationType);
            if (internalMapper instanceof MapperAdapter) {
                MapperAdapter mapperAdapter = (MapperAdapter)internalMapper;
                return mapperAdapter.getMapper();
            }
            throw new IllegalStateException(String.format("Could not find mapping for filter model. Mapping was %s to %s.", sourceType.getName(), destinationType.getName()));
        }

        public MappedResult performValueTransformation(Object value) {
            Transformation singleMatch = this.getSingleMatch();
            return singleMatch.performValueTransformation(value, null);
        }

        private Transformation getSingleMatch() {
            if (!this.hasSingleResult()) {
                throw new IllegalStateException("A value transformation cannot be performed on the mapping search result, because the result is unambiguous. Please use hasSingleResult() before calling this method.");
            }
            return this.transformations.get(0);
        }

        public String getSourcePropertyName() {
            return this.getSingleMatch().getSourcePropertyName();
        }

        public String getDestinationPropertyName() {
            return this.getSingleMatch().getDestinationPropertyName();
        }

        public PropertyDescriptor getSource() {
            return this.getSingleMatch().getSourceProperty();
        }

        public PropertyDescriptor getDestination() {
            return this.getSingleMatch().getDestinationProperty();
        }

        public String toString() {
            return "TransformationSearchResult [hasResult()=" + this.hasResult() + ", hasSingleResult()=" + this.hasSingleResult() + ", transformations=" + this.transformations + "]";
        }
    }
}

