/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap;

import com.remondis.propertypath.api.PropertyPath;
import com.remondis.remap.AssertConfiguration;
import com.remondis.remap.Lang;
import com.remondis.remap.PropertyPathCollectionTransformation;
import com.remondis.remap.ReplaceCollectionTransformation;
import com.remondis.remap.TypedPropertyDescriptor;
import java.util.Collection;
import java.util.function.Function;

public class ReplaceCollectionAssertBuilder<S, D, RD, RS> {
    private TypedPropertyDescriptor<Collection<RS>> sourceProperty;
    private TypedPropertyDescriptor<Collection<RD>> destProperty;
    private AssertConfiguration<S, D> asserts;

    ReplaceCollectionAssertBuilder(TypedPropertyDescriptor<Collection<RS>> sourceProperty, TypedPropertyDescriptor<Collection<RD>> destProperty, AssertConfiguration<S, D> asserts) {
        this.sourceProperty = sourceProperty;
        this.destProperty = destProperty;
        this.asserts = asserts;
    }

    public <E extends Exception> AssertConfiguration<S, D> withPropertyPath(PropertyPath<RD, RS, E> propertyPath) {
        Lang.denyNull("propertyPath", propertyPath);
        PropertyPathCollectionTransformation replace = new PropertyPathCollectionTransformation(this.asserts.getMapping(), this.sourceProperty.property, this.destProperty.property, propertyPath);
        this.asserts.addAssertion(replace);
        return this.asserts;
    }

    public AssertConfiguration<S, D> withPropertyPathAndTransformation(PropertyPath<?, RS, ?> propertyPath) {
        Lang.denyNull("propertyPath", propertyPath);
        PropertyPathCollectionTransformation replace = new PropertyPathCollectionTransformation(this.asserts.getMapping(), this.sourceProperty.property, this.destProperty.property, propertyPath, Function.identity());
        this.asserts.addAssertion(replace);
        return this.asserts;
    }

    public AssertConfiguration<S, D> andTest(Function<RS, RD> transformation) {
        Lang.denyNull("tranfromation", transformation);
        ReplaceCollectionTransformation<RS, RD> replace = new ReplaceCollectionTransformation<RS, RD>(this.asserts.getMapping(), this.sourceProperty.property, this.destProperty.property, transformation, false);
        this.asserts.addAssertion(replace);
        return this.asserts;
    }

    public AssertConfiguration<S, D> andSkipWhenNull() {
        ReplaceCollectionTransformation replace = new ReplaceCollectionTransformation(this.asserts.getMapping(), this.sourceProperty.property, this.destProperty.property, null, true);
        this.asserts.addAssertion(replace);
        return this.asserts;
    }
}

