/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap;

import com.remondis.remap.MappedResult;
import com.remondis.remap.MappingConfiguration;
import com.remondis.remap.MappingException;
import com.remondis.remap.Properties;
import com.remondis.remap.ReflectionUtil;
import com.remondis.remap.SkipWhenNullTransformation;
import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collector;

class ReplaceCollectionTransformation<RS, RD>
extends SkipWhenNullTransformation<RS, RD> {
    private static final String REPLACE_MSG = "Replacing %s\n           with %s using transformation";
    private static final String REPLACE_SKIPPED_MSG = "Replacing but skipping when null %s\n           with %s using transformation";
    private Function<RS, RD> transformation;
    private boolean skipWhenNull;

    ReplaceCollectionTransformation(MappingConfiguration<?, ?> mapping, PropertyDescriptor sourceProperty, PropertyDescriptor destProperty, Function<RS, RD> transformation, boolean skipWhenNull) {
        super(mapping, sourceProperty, destProperty);
        this.transformation = transformation;
        this.skipWhenNull = skipWhenNull;
    }

    @Override
    protected void performTransformation(PropertyDescriptor sourceProperty, Object source, PropertyDescriptor destinationProperty, Object destination) throws MappingException {
        Object sourceValue = this.readOrFail(sourceProperty, source);
        MappedResult result = this.performValueTransformation(sourceValue, destination);
        if (result.hasValue()) {
            this.writeOrFail(destinationProperty, destination, result.getValue());
        }
    }

    @Override
    protected MappedResult performValueTransformation(Object source, Object destination) throws MappingException {
        if (source == null) {
            return MappedResult.skip();
        }
        Collection collection = (Collection)source;
        Class<?> destinationCollectionType = this.destinationProperty.getPropertyType();
        Collector collector = ReflectionUtil.getCollector(destinationCollectionType);
        Collection destinationValue = null;
        destinationValue = this.skipWhenNull ? (Collection)collection.stream().filter(i -> i != null).map(sourceItem -> this.transformation.apply(sourceItem)).collect(collector) : (Collection)collection.stream().map(sourceItem -> {
            Object sourceItem2 = null;
            sourceItem2 = sourceItem;
            return this.transformation.apply(sourceItem2);
        }).collect(collector);
        return MappedResult.value(destinationValue);
    }

    @Override
    protected void validateTransformation() throws MappingException {
    }

    @Override
    Function<RS, RD> getTransformation() {
        return this.transformation;
    }

    @Override
    boolean isSkipWhenNull() {
        return this.skipWhenNull;
    }

    @Override
    public String toString(boolean detailed) {
        if (this.skipWhenNull) {
            return String.format(REPLACE_SKIPPED_MSG, Properties.asString(this.sourceProperty, detailed), Properties.asString(this.destinationProperty, detailed));
        }
        return String.format(REPLACE_MSG, Properties.asString(this.sourceProperty, detailed), Properties.asString(this.destinationProperty, detailed));
    }
}

