/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap;

import com.remondis.remap.MappedResult;
import com.remondis.remap.MappingConfiguration;
import com.remondis.remap.MappingException;
import com.remondis.remap.Properties;
import com.remondis.remap.SkipWhenNullTransformation;
import java.beans.PropertyDescriptor;
import java.util.function.Function;

class ReplaceTransformation<RS, RD>
extends SkipWhenNullTransformation<RS, RD> {
    private static final String REPLACE_MSG = "Replacing %s\n           with %s using transformation";
    private static final String REPLACE_SKIPPED_MSG = "Replacing but skipping when null %s\n           with %s using transformation";
    private Function<RS, RD> transformation;
    private boolean skipWhenNull;

    ReplaceTransformation(MappingConfiguration<?, ?> mapping, PropertyDescriptor sourceProperty, PropertyDescriptor destProperty, Function<RS, RD> transformation, boolean skipWhenNull) {
        super(mapping, sourceProperty, destProperty);
        this.transformation = transformation;
        this.skipWhenNull = skipWhenNull;
    }

    @Override
    protected void performTransformation(PropertyDescriptor sourceProperty, Object source, PropertyDescriptor destinationProperty, Object destination) throws MappingException {
        Object sourceValue = this.readOrFail(sourceProperty, source);
        MappedResult result = this.performValueTransformation(sourceValue, destination);
        if (result.hasValue()) {
            this.writeOrFail(destinationProperty, destination, result.getValue());
        }
    }

    @Override
    protected MappedResult performValueTransformation(Object source, Object destination) throws MappingException {
        if (source == null && this.skipWhenNull) {
            return MappedResult.skip();
        }
        RD destinationValue = this.transformation.apply(source);
        return MappedResult.value(destinationValue);
    }

    @Override
    protected void validateTransformation() throws MappingException {
    }

    @Override
    public String toString(boolean detailed) {
        if (this.skipWhenNull) {
            return String.format(REPLACE_SKIPPED_MSG, Properties.asString(this.sourceProperty, detailed), Properties.asString(this.destinationProperty, detailed));
        }
        return String.format(REPLACE_MSG, Properties.asString(this.sourceProperty, detailed), Properties.asString(this.destinationProperty, detailed));
    }

    @Override
    Function<RS, RD> getTransformation() {
        return this.transformation;
    }

    @Override
    boolean isSkipWhenNull() {
        return this.skipWhenNull;
    }
}

