/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap;

import com.remondis.remap.InternalMapper;
import com.remondis.remap.Lang;
import com.remondis.remap.Mapping;
import com.remondis.remap.MappingConfiguration;
import com.remondis.remap.Projection;
import com.remondis.remap.RestructureTransformation;
import com.remondis.remap.TypedPropertyDescriptor;
import java.util.Map;
import java.util.function.Consumer;

public class RestructureBuilder<S, D, RD> {
    private MappingConfiguration<S, D> mappingConfiguration;
    private TypedPropertyDescriptor<RD> typedPropertyDescriptor;

    RestructureBuilder(MappingConfiguration<S, D> mappingConfiguration, TypedPropertyDescriptor<RD> typedPropertyDescriptor) {
        this.mappingConfiguration = mappingConfiguration;
        this.typedPropertyDescriptor = typedPropertyDescriptor;
    }

    public MappingConfiguration<S, D> implicitly() {
        return this.createRestructure(conf -> {}, false);
    }

    public MappingConfiguration<S, D> applying(Consumer<MappingConfiguration<S, RD>> restructureMappingConfiguration) {
        Lang.denyNull("restructureMappingConfiguration", restructureMappingConfiguration);
        boolean applyingSpecificConfiguration = true;
        return this.createRestructure(restructureMappingConfiguration, applyingSpecificConfiguration);
    }

    private MappingConfiguration<S, D> createRestructure(Consumer<MappingConfiguration<S, RD>> restructureMappingConfiguration, boolean applyingSpecificConfiguration) {
        Map<Projection<?, ?>, InternalMapper<?, ?>> mappers = this.mappingConfiguration.getMappers();
        MappingConfiguration config = Mapping.from(this.mappingConfiguration.getSource()).to(this.typedPropertyDescriptor.property.getPropertyType());
        config.omitOtherSourceProperties();
        mappers.entrySet().stream().forEach(entry -> {
            InternalMapper mapper = (InternalMapper)entry.getValue();
            config.useInternalMapper(mapper);
        });
        restructureMappingConfiguration.accept(config);
        RestructureTransformation restructureTransformation = new RestructureTransformation(config, null, this.typedPropertyDescriptor.property, null, applyingSpecificConfiguration);
        this.mappingConfiguration.addDestinationMapping(this.typedPropertyDescriptor.property, restructureTransformation);
        return this.mappingConfiguration;
    }
}

