/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap;

import com.remondis.remap.MappedResult;
import com.remondis.remap.MappingConfiguration;
import com.remondis.remap.MappingException;
import com.remondis.remap.Properties;
import com.remondis.remap.Transformation;
import java.beans.PropertyDescriptor;
import java.util.function.Function;

class SetTransformation<S, D, RD>
extends Transformation {
    private static final String MSG = "Set %s with a custom value supplier.";
    private Function<S, RD> transformation;

    SetTransformation(MappingConfiguration<S, D> mapping, PropertyDescriptor destProperty, Function<S, RD> transformation) {
        super(mapping, null, destProperty);
        this.transformation = transformation;
    }

    @Override
    protected void performTransformation(PropertyDescriptor sourceProperty, Object source, PropertyDescriptor destinationProperty, Object destination) throws MappingException {
        MappedResult result = this.performValueTransformation(source, destination);
        if (result.hasValue()) {
            this.writeOrFail(destinationProperty, destination, result.getValue());
        }
    }

    @Override
    protected MappedResult performValueTransformation(Object source, Object destination) throws MappingException {
        RD destinationValue = this.transformation.apply(source);
        return MappedResult.value(destinationValue);
    }

    @Override
    protected void validateTransformation() throws MappingException {
    }

    @Override
    public String toString(boolean detailed) {
        return String.format(MSG, Properties.asString(this.destinationProperty, detailed));
    }
}

