/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap.utils.propertywalker;

import com.remondis.remap.utils.propertywalker.BiPropertyVisitor;
import com.remondis.remap.utils.propertywalker.PropertyAccess;
import com.remondis.remap.utils.propertywalker.VisitorFunction;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class BiRecursivePropertyWalker<R, T> {
    BiRecursivePropertyWalker<R, ?> rootWalker;
    Function<R, T> fromRootExctractor;
    Class<T> beanType;
    List<BiPropertyVisitor<T, ?>> visitors;

    private BiRecursivePropertyWalker(Class<T> beanType) {
        this.beanType = beanType;
        this.rootWalker = this;
        this.fromRootExctractor = Function.identity();
        this.visitors = new LinkedList();
    }

    private <TT> BiRecursivePropertyWalker(BiRecursivePropertyWalker<R, ?> rootWalker, Function<R, TT> fromRootExctractor, Function<TT, T> propertyExtractor, Class<T> beanType) {
        this.rootWalker = rootWalker;
        this.fromRootExctractor = fromRootExctractor.andThen(propertyExtractor);
        this.beanType = beanType;
        this.visitors = new LinkedList();
    }

    public <TT> BiRecursivePropertyWalker<R, TT> goInto(Function<T, TT> propertyExtractor, BiConsumer<T, TT> propertyWriter, Class<TT> beanType) {
        Objects.requireNonNull(propertyExtractor, "propertyExtractor may not be null!");
        Objects.requireNonNull(beanType, "beanType may not be null!");
        final BiRecursivePropertyWalker<R, TT> recursivePropertyWalker = new BiRecursivePropertyWalker<R, TT>(this.rootWalker, this.fromRootExctractor, propertyExtractor, beanType);
        this.addProperty(propertyExtractor, propertyWriter, new VisitorFunction<T, TT>(){

            @Override
            public void consume(PropertyAccess<T, TT> access) {
                recursivePropertyWalker.execute(access.sourceProperty().get(), access.targetProperty().get());
            }
        });
        return recursivePropertyWalker;
    }

    public <P> BiRecursivePropertyWalker<R, T> addProperty(Function<T, P> propertyExtractor, BiConsumer<T, P> propertyWriter, VisitorFunction<T, P> biConsumer) {
        Objects.requireNonNull(propertyExtractor, "propertyExtractor may not be null!");
        BiPropertyVisitor<T, P> pv = new BiPropertyVisitor<T, P>(this.beanType, propertyExtractor, propertyWriter, biConsumer);
        this.visitors.add(pv);
        return this;
    }

    public void execute(T source, T target) {
        this.visitors.parallelStream().forEach(visitor -> visitor.execute(source, target));
    }

    public static <T> BiRecursivePropertyWalker<T, T> create(Class<T> beanType) {
        return new BiRecursivePropertyWalker(beanType);
    }

    public BiRecursivePropertyWalker<R, R> build() {
        return this.rootWalker;
    }
}

