/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;

public class ClassHierarchyIterator
implements Iterator<Class<?>> {
    private Queue<Class<?>> remaining = new LinkedList();
    private Set<Class<?>> visited = new LinkedHashSet();

    public ClassHierarchyIterator(Class<?> initial) {
        this.append(initial);
    }

    private void append(Class<?> toAppend) {
        if (Objects.nonNull(toAppend) && !this.visited.contains(toAppend)) {
            this.remaining.add(toAppend);
            this.visited.add(toAppend);
        }
    }

    @Override
    public boolean hasNext() {
        return this.remaining.size() > 0;
    }

    @Override
    public Class<?> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Class<?> polled = this.remaining.poll();
        this.append(polled.getSuperclass());
        for (Class<?> superInterface : polled.getInterfaces()) {
            this.append(superInterface);
        }
        return polled;
    }
}

