/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap;

import com.remondis.remap.MappingException;
import com.remondis.remap.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;

public class InterceptionHandler<T> {
    T proxyObject;
    ThreadLocal<List<String>> threadLocalPropertyNames = new ThreadLocal();

    @RuntimeType
    public Object intercept(@Origin Method method, @AllArguments Object[] args) throws Exception {
        if (ReflectionUtil.isGetter(method)) {
            InterceptionHandler.denyNoReturnType(method);
            String propertyName = ReflectionUtil.toPropertyName(method);
            List<String> propertyNames = this.threadLocalPropertyNames.get();
            if (Objects.isNull(propertyNames)) {
                propertyNames = new LinkedList<String>();
                this.threadLocalPropertyNames.set(propertyNames);
            }
            propertyNames.add(propertyName);
            return InterceptionHandler.nullOrDefaultValue(method.getReturnType());
        }
        if (InterceptionHandler.isObjectMethod(method)) {
            return ReflectionUtil.invokeMethodProxySafe(method, this, args);
        }
        return InterceptionHandler.nullOrDefaultValue(method.getReturnType());
    }

    public void setProxyObject(T proxyObject) {
        this.proxyObject = proxyObject;
    }

    public T getProxyObject() {
        return this.proxyObject;
    }

    public List<String> getTrackedPropertyNames() {
        List<String> list = this.threadLocalPropertyNames.get();
        this.reset();
        if (Objects.isNull(list)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    void reset() {
        this.threadLocalPropertyNames.remove();
    }

    public boolean hasTrackedProperties() {
        return Objects.nonNull(this.threadLocalPropertyNames.get());
    }

    private static void denyNoReturnType(Method method) {
        if (!ReflectionUtil.hasReturnType(method)) {
            throw MappingException.noReturnTypeOnGetter(method);
        }
    }

    private static Object nullOrDefaultValue(Class<?> returnType) {
        if (returnType.isPrimitive()) {
            return ReflectionUtil.defaultValue(returnType);
        }
        return null;
    }

    private static boolean isObjectMethod(Method method) {
        return method.getDeclaringClass() == Object.class;
    }
}

