/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap;

import com.remondis.remap.ClassHierarchyIterator;
import com.remondis.remap.InterceptionHandler;
import com.remondis.remap.MappingException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class InvocationSensor<T> {
    static Map<Class<?>, InterceptionHandler<?>> interceptionHandlerCache = new ConcurrentHashMap();
    private InterceptionHandler<T> interceptionHandler;

    public InvocationSensor(Class<T> superType) {
        ClassLoader classLoader = Objects.isNull(superType) || Objects.isNull(superType.getClassLoader()) ? ClassLoader.getSystemClassLoader() : superType.getClassLoader();
        try {
            if (interceptionHandlerCache.containsKey(superType)) {
                this.interceptionHandler = interceptionHandlerCache.get(superType);
            } else {
                InterceptionHandler<Object> interceptionHandler = new InterceptionHandler<Object>();
                Object po = null;
                po = new ByteBuddy().subclass(superType).method(this.isDeclaredByClassHierarchy(superType)).intercept((Implementation)MethodDelegation.to(interceptionHandler)).make().load(classLoader, (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                interceptionHandler.setProxyObject(po);
                interceptionHandlerCache.put(superType, interceptionHandler);
                this.interceptionHandler = interceptionHandler;
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new MappingException(String.format("Error while creating proxy for class '%s'", superType.getCanonicalName()), ex);
        }
    }

    private ElementMatcher.Junction<MethodDescription> isDeclaredByClassHierarchy(Class<T> type) {
        ClassHierarchyIterator classHierarchyIterator = new ClassHierarchyIterator(type);
        ElementMatcher.Junction methodDescriptionJunction = null;
        while (classHierarchyIterator.hasNext()) {
            Object next = classHierarchyIterator.next();
            if (Objects.isNull(methodDescriptionJunction)) {
                methodDescriptionJunction = ElementMatchers.isDeclaredBy((Class)next);
                continue;
            }
            methodDescriptionJunction = methodDescriptionJunction.or((ElementMatcher)ElementMatchers.isDeclaredBy((Class)next));
        }
        return methodDescriptionJunction;
    }

    T getSensor() {
        return this.interceptionHandler.getProxyObject();
    }

    List<String> getTrackedPropertyNames() {
        List<String> trackesPropertyNames = this.interceptionHandler.getTrackedPropertyNames();
        return trackesPropertyNames;
    }

    boolean hasTrackedProperties() {
        boolean hasTrackedProperties = this.interceptionHandler.hasTrackedProperties();
        return hasTrackedProperties;
    }
}

