/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap;

import com.remondis.remap.FieldSelector;
import com.remondis.remap.InternalMapper;
import com.remondis.remap.InvocationSensor;
import com.remondis.remap.Lang;
import com.remondis.remap.MapTransformation;
import com.remondis.remap.Mapper;
import com.remondis.remap.MapperAdapter;
import com.remondis.remap.MappingException;
import com.remondis.remap.OmitTransformation;
import com.remondis.remap.Projection;
import com.remondis.remap.Properties;
import com.remondis.remap.ReassignBuilder;
import com.remondis.remap.ReflectionUtil;
import com.remondis.remap.ReplaceBuilder;
import com.remondis.remap.ReplaceCollectionBuilder;
import com.remondis.remap.RestructureBuilder;
import com.remondis.remap.SetBuilder;
import com.remondis.remap.Target;
import com.remondis.remap.Transformation;
import com.remondis.remap.TypeMapping;
import com.remondis.remap.TypedPropertyDescriptor;
import com.remondis.remap.TypedSelector;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class MappingConfiguration<S, D> {
    static final String OMIT_FIELD_DEST = "omit in destination";
    static final String OMIT_FIELD_SOURCE = "omit in source";
    private Class<S> source;
    private Class<D> destination;
    private Map<Projection<?, ?>, InternalMapper<?, ?>> mappers;
    private Set<Transformation> mappings;
    private Set<PropertyDescriptor> mappedSourceProperties;
    private Set<PropertyDescriptor> mappedDestinationProperties;
    private boolean omitOtherSourceProperties;
    private boolean omitOtherDestinationProperties;
    private boolean noImplicitMappings;
    private boolean writeNullIfSourceIsNull;
    private boolean allowFluentSetters;
    private InvocationSensor<?> sourceInvocationSensor;
    private InvocationSensor<?> destinationInvocationSensor;

    MappingConfiguration(Class<S> source, Class<D> destination) {
        this.source = source;
        this.destination = destination;
        this.mappings = new HashSet<Transformation>();
        this.mappedSourceProperties = new HashSet<PropertyDescriptor>();
        this.mappedDestinationProperties = new HashSet<PropertyDescriptor>();
        this.mappers = new Hashtable();
    }

    private InvocationSensor<?> getSourceInvocationSensor() {
        if (this.sourceInvocationSensor == null) {
            this.sourceInvocationSensor = new InvocationSensor<S>(this.source);
        }
        return this.sourceInvocationSensor;
    }

    private InvocationSensor<?> getDestinationeInvocationSensor() {
        if (this.destinationInvocationSensor == null) {
            this.destinationInvocationSensor = new InvocationSensor<D>(this.destination);
        }
        return this.destinationInvocationSensor;
    }

    public MappingConfiguration<S, D> omitInDestination(FieldSelector<D> destinationSelector) {
        Lang.denyNull("destinationSelector", destinationSelector);
        PropertyDescriptor propertyDescriptor = MappingConfiguration.getPropertyFromFieldSelector(this.getDestinationeInvocationSensor(), Target.DESTINATION, OMIT_FIELD_DEST, this.destination, destinationSelector, this.allowFluentSetters);
        OmitTransformation omitDestination = OmitTransformation.omitDestination(this, propertyDescriptor);
        this.omitMapping(this.mappedDestinationProperties, propertyDescriptor, omitDestination);
        return this;
    }

    private void omitMapping(Set<PropertyDescriptor> mappedDestinationProperties, PropertyDescriptor propertyDescriptor, OmitTransformation omitDestination) {
        MappingConfiguration.denyAlreadyMappedProperty(mappedDestinationProperties, propertyDescriptor);
        mappedDestinationProperties.add(propertyDescriptor);
        this.mappings.add(omitDestination);
    }

    public MappingConfiguration<S, D> omitOthers() {
        this.omitOtherSourceProperties();
        this.omitOtherDestinationProperties();
        return this;
    }

    public MappingConfiguration<S, D> omitOtherDestinationProperties() {
        this.omitOtherDestinationProperties = true;
        return this;
    }

    public MappingConfiguration<S, D> omitOtherSourceProperties() {
        this.omitOtherSourceProperties = true;
        return this;
    }

    public MappingConfiguration<S, D> omitInSource(FieldSelector<S> sourceSelector) {
        Lang.denyNull("sourceSelector", sourceSelector);
        PropertyDescriptor propertyDescriptor = MappingConfiguration.getPropertyFromFieldSelector(this.getSourceInvocationSensor(), Target.SOURCE, OMIT_FIELD_SOURCE, this.source, sourceSelector, this.allowFluentSetters);
        OmitTransformation omitSource = OmitTransformation.omitSource(this, propertyDescriptor);
        this.omitMapping(this.mappedSourceProperties, propertyDescriptor, omitSource);
        return this;
    }

    public <RS> ReassignBuilder<S, D> reassign(FieldSelector<S> sourceSelector) {
        Lang.denyNull("sourceSelector", sourceSelector);
        PropertyDescriptor typedSourceProperty = MappingConfiguration.getPropertyFromFieldSelector(this.getSourceInvocationSensor(), Target.SOURCE, "assign", this.source, sourceSelector, this.allowFluentSetters);
        ReassignBuilder reassignBuilder = new ReassignBuilder(typedSourceProperty, this.destination, this);
        return reassignBuilder;
    }

    public <RD, RS> ReplaceBuilder<S, D, RD, RS> replace(TypedSelector<RS, S> sourceSelector, TypedSelector<RD, D> destinationSelector) {
        Lang.denyNull("sourceSelector", sourceSelector);
        Lang.denyNull("destinationSelector", destinationSelector);
        TypedPropertyDescriptor<RS> sourceProperty = MappingConfiguration.getTypedPropertyFromFieldSelector(this.getSourceInvocationSensor(), Target.SOURCE, "transform", this.source, sourceSelector, this.allowFluentSetters);
        TypedPropertyDescriptor<RD> destProperty = MappingConfiguration.getTypedPropertyFromFieldSelector(this.getDestinationeInvocationSensor(), Target.DESTINATION, "transform", this.destination, destinationSelector, this.allowFluentSetters);
        ReplaceBuilder builder = new ReplaceBuilder(sourceProperty, destProperty, this);
        return builder;
    }

    public <RD> SetBuilder<S, D, RD> set(TypedSelector<RD, D> destinationSelector) {
        Lang.denyNull("destinationSelector", destinationSelector);
        TypedPropertyDescriptor<RD> destProperty = MappingConfiguration.getTypedPropertyFromFieldSelector(this.getDestinationeInvocationSensor(), Target.DESTINATION, "transform", this.destination, destinationSelector, this.allowFluentSetters);
        SetBuilder builder = new SetBuilder(destProperty, this);
        return builder;
    }

    public <RD> RestructureBuilder<S, D, RD> restructure(TypedSelector<RD, D> destinationSelector) {
        Lang.denyNull("destinationSelector", destinationSelector);
        TypedPropertyDescriptor<RD> destProperty = MappingConfiguration.getTypedPropertyFromFieldSelector(this.getDestinationeInvocationSensor(), Target.DESTINATION, "transform", this.destination, destinationSelector, this.allowFluentSetters);
        return new RestructureBuilder(this, destProperty);
    }

    public <RD, RS> ReplaceCollectionBuilder<S, D, RD, RS> replaceCollection(TypedSelector<Collection<RS>, S> sourceSelector, TypedSelector<Collection<RD>, D> destinationSelector) {
        Lang.denyNull("sourceSelector", sourceSelector);
        Lang.denyNull("destinationSelector", destinationSelector);
        TypedPropertyDescriptor<Collection<RS>> sourceProperty = MappingConfiguration.getTypedPropertyFromFieldSelector(this.getSourceInvocationSensor(), Target.SOURCE, "transform", this.source, sourceSelector, this.allowFluentSetters);
        TypedPropertyDescriptor<Collection<RD>> destProperty = MappingConfiguration.getTypedPropertyFromFieldSelector(this.getDestinationeInvocationSensor(), Target.DESTINATION, "transform", this.destination, destinationSelector, this.allowFluentSetters);
        ReplaceCollectionBuilder builder = new ReplaceCollectionBuilder(sourceProperty, destProperty, this);
        return builder;
    }

    protected void addMapping(PropertyDescriptor sourceProperty, PropertyDescriptor destProperty, Transformation transformation) {
        this.denyAlreadyOmittedProperty(sourceProperty);
        MappingConfiguration.denyAlreadyMappedProperty(this.mappedDestinationProperties, destProperty);
        this.mappedSourceProperties.add(sourceProperty);
        this.mappedDestinationProperties.add(destProperty);
        this.mappings.add(transformation);
    }

    protected void addDestinationMapping(PropertyDescriptor destProperty, Transformation setTransformation) {
        MappingConfiguration.denyAlreadyMappedProperty(this.mappedDestinationProperties, destProperty);
        this.mappedDestinationProperties.add(destProperty);
        this.mappings.add(setTransformation);
    }

    private void denyAlreadyOmittedProperty(PropertyDescriptor sourceProperty) {
        if (this.mappedSourceProperties.contains(sourceProperty)) {
            this.mappings.stream().forEach(t -> {
                PropertyDescriptor omitSourceProperty = t.getSourceProperty();
                if (t instanceof OmitTransformation && Objects.nonNull(omitSourceProperty) && omitSourceProperty.equals(sourceProperty)) {
                    throw MappingException.alreadyMappedProperty(sourceProperty);
                }
            });
        }
    }

    public Mapper<S, D> mapper() {
        if (!this.noImplicitMappings) {
            this.addStrictMapping();
        }
        if (this.omitOtherSourceProperties) {
            this.addOmitForSource();
        }
        if (this.omitOtherDestinationProperties) {
            this.addOmitForDestination();
        }
        this.validateMapping();
        this.sourceInvocationSensor = null;
        this.destinationInvocationSensor = null;
        return new Mapper(this);
    }

    private void addOmitForDestination() {
        Set<PropertyDescriptor> unmappedDestinationProperties = this.getUnmappedDestinationProperties();
        for (PropertyDescriptor propertyDescriptor : unmappedDestinationProperties) {
            OmitTransformation omitDestination = OmitTransformation.omitDestination(this, propertyDescriptor);
            this.omitMapping(this.mappedDestinationProperties, propertyDescriptor, omitDestination);
        }
    }

    private void addOmitForSource() {
        Set unmappedSourcePropertyNames = this.getUnmappedSourceProperties().stream().map(FeatureDescriptor::getName).collect(Collectors.toSet());
        this.getUnmappedSourceProperties().stream().filter(pd -> unmappedSourcePropertyNames.contains(pd.getName())).forEach(pd -> {
            OmitTransformation omitSource = OmitTransformation.omitSource(this, pd);
            this.omitMapping(this.mappedSourceProperties, (PropertyDescriptor)pd, omitSource);
        });
    }

    private void addStrictMapping() {
        Set<PropertyDescriptor> unmappedDestinationProperties = this.getUnmappedDestinationProperties();
        Set unmappedDestinationPropertyNames = unmappedDestinationProperties.stream().map(FeatureDescriptor::getName).collect(Collectors.toSet());
        this.getUnmappedSourceProperties().stream().filter(pd -> unmappedDestinationPropertyNames.contains(pd.getName())).forEach(pd -> {
            PropertyDescriptor destinationProperty = this.getPropertyDescriptorByPropertyName(unmappedDestinationProperties, pd.getName());
            MapTransformation transformation = new MapTransformation(this, (PropertyDescriptor)pd, destinationProperty);
            this.addMapping((PropertyDescriptor)pd, destinationProperty, transformation);
        });
    }

    private PropertyDescriptor getPropertyDescriptorByPropertyName(Set<PropertyDescriptor> descriptors, String propertyName) {
        Set matchedPropertiesByName = descriptors.stream().filter(pd -> pd.getName().equals(propertyName)).collect(Collectors.toSet());
        if (matchedPropertiesByName.isEmpty() || matchedPropertiesByName.size() > 1) {
            throw new MappingException(String.format("Cannot assign source property '%s' to destination, but this was determined to be possible - this is an implementation fault.", propertyName));
        }
        return (PropertyDescriptor)matchedPropertiesByName.iterator().next();
    }

    private void validateMapping() {
        Set<PropertyDescriptor> unmapped = this.getUnmappedProperties();
        if (!unmapped.isEmpty()) {
            throw MappingException.unmappedProperties(unmapped);
        }
        for (Transformation t : this.mappings) {
            t.validateTransformation();
        }
    }

    private Set<PropertyDescriptor> getUnmappedProperties() {
        HashSet<PropertyDescriptor> unmapped = new HashSet<PropertyDescriptor>();
        unmapped.addAll(this.getUnmappedSourceProperties());
        unmapped.addAll(this.getUnmappedDestinationProperties());
        return unmapped;
    }

    private Set<PropertyDescriptor> getUnmappedDestinationProperties() {
        return this.getUnmappedProperties(this.destination, this.mappedDestinationProperties, Target.DESTINATION);
    }

    private Set<PropertyDescriptor> getUnmappedSourceProperties() {
        return this.getUnmappedProperties(this.source, this.mappedSourceProperties, Target.SOURCE);
    }

    private <T> Set<PropertyDescriptor> getUnmappedProperties(Class<T> type, Set<PropertyDescriptor> mappedSourceProperties, Target targetType) {
        Set<PropertyDescriptor> allSourceProperties = Properties.getProperties(type, targetType, this.allowFluentSetters);
        allSourceProperties.removeAll(mappedSourceProperties);
        return allSourceProperties;
    }

    static <R, T> TypedPropertyDescriptor<R> getTypedPropertyFromFieldSelector(Target target, String configurationMethod, Class<T> sensorType, TypedSelector<R, T> selector, boolean fluentSetters) {
        InvocationSensor<T> invocationSensor = new InvocationSensor<T>(sensorType);
        return MappingConfiguration.getTypedPropertyFromFieldSelector(invocationSensor, target, configurationMethod, sensorType, selector, fluentSetters);
    }

    static <R, T> TypedPropertyDescriptor<R> getTypedPropertyFromFieldSelector(InvocationSensor<?> invocationSensor, Target target, String configurationMethod, Class<T> sensorType, TypedSelector<R, T> selector, boolean fluentSetters) {
        Object sensor = invocationSensor.getSensor();
        R returnValue = selector.selectField(sensor);
        if (invocationSensor.hasTrackedProperties()) {
            List<String> trackedPropertyNames = invocationSensor.getTrackedPropertyNames();
            MappingConfiguration.denyMultipleInteractions(configurationMethod, trackedPropertyNames);
            String propertyName = trackedPropertyNames.get(0);
            PropertyDescriptor property = MappingConfiguration.getPropertyDescriptorOrFail(target, sensorType, propertyName, fluentSetters);
            TypedPropertyDescriptor tpd = new TypedPropertyDescriptor();
            tpd.returnValue = returnValue;
            tpd.property = property;
            return tpd;
        }
        throw MappingException.zeroInteractions(configurationMethod);
    }

    static <T> PropertyDescriptor getPropertyFromFieldSelector(Target target, String configurationMethod, Class<T> sensorType, FieldSelector<T> selector, boolean fluentSetters) {
        InvocationSensor<T> invocationSensor = new InvocationSensor<T>(sensorType);
        return MappingConfiguration.getPropertyFromFieldSelector(invocationSensor, target, configurationMethod, sensorType, selector, fluentSetters);
    }

    static <T> PropertyDescriptor getPropertyFromFieldSelector(InvocationSensor<?> invocationSensor, Target target, String configurationMethod, Class<T> sensorType, FieldSelector<T> selector, boolean fluentSetters) {
        Object sensor = invocationSensor.getSensor();
        selector.selectField(sensor);
        if (invocationSensor.hasTrackedProperties()) {
            List<String> trackedPropertyNames = invocationSensor.getTrackedPropertyNames();
            MappingConfiguration.denyMultipleInteractions(configurationMethod, trackedPropertyNames);
            String propertyName = trackedPropertyNames.get(0);
            return MappingConfiguration.getPropertyDescriptorOrFail(target, sensorType, propertyName, fluentSetters);
        }
        throw MappingException.zeroInteractions(configurationMethod);
    }

    static PropertyDescriptor getPropertyDescriptorOrFail(Target target, Class<?> type, String propertyName, boolean fluentSetters) {
        Optional<PropertyDescriptor> property = Properties.getProperties(type, target, fluentSetters).stream().filter(pd -> pd.getName().equals(propertyName)).findFirst();
        if (property.isPresent()) {
            return property.get();
        }
        throw MappingException.notAProperty(type, propertyName);
    }

    static void denyMultipleInteractions(String configurationMethod, List<String> trackedPropertyNames) {
        if (trackedPropertyNames.size() > 1) {
            throw MappingException.multipleInteractions(configurationMethod, trackedPropertyNames);
        }
    }

    static void denyAlreadyMappedProperty(Set<PropertyDescriptor> mappedProperties, PropertyDescriptor propertyDescriptor) {
        if (mappedProperties.contains(propertyDescriptor)) {
            throw MappingException.alreadyMappedProperty(propertyDescriptor);
        }
    }

    public MappingConfiguration<S, D> useMapper(Mapper<?, ?> mapper) {
        Lang.denyNull("mapper", mapper);
        MapperAdapter interalMapper = new MapperAdapter(mapper);
        this.useInternalMapper(interalMapper);
        return this;
    }

    public MappingConfiguration<S, D> useMapper(TypeMapping<?, ?> typeMapping) {
        Lang.denyNull("typeMapping", typeMapping);
        this.useInternalMapper(typeMapping);
        return this;
    }

    public MappingConfiguration<S, D> noImplicitMappings() {
        this.noImplicitMappings = true;
        return this;
    }

    @Deprecated
    public MappingConfiguration<S, D> writeNullIfSourceIsNull() {
        this.writeNullIfSourceIsNull = true;
        return this;
    }

    public MappingConfiguration<S, D> allowFluentSetters() {
        this.allowFluentSetters = true;
        return this;
    }

    public boolean isFluentSettersAllowed() {
        return this.allowFluentSetters;
    }

    boolean isNoImplicitMappings() {
        return this.noImplicitMappings;
    }

    protected void useInternalMapper(InternalMapper<?, ?> interalMapper) {
        Projection<?, ?> projection = interalMapper.getProjection();
        if (this.mappers.containsKey(projection)) {
            throw MappingException.duplicateMapper(projection.getSource(), projection.getDestination());
        }
        this.mappers.put(projection, interalMapper);
    }

    <S1, D1> InternalMapper<S1, D1> getMapperFor(PropertyDescriptor sourceProperty, Class<S1> sourceType, PropertyDescriptor destinationProperty, Class<D1> destinationType) {
        Projection<S1, D1> projection = new Projection<S1, D1>(sourceType, destinationType);
        if (this.mappers.containsKey(projection)) {
            return this.mappers.get(projection);
        }
        throw MappingException.noMapperFound(sourceProperty, sourceType, destinationProperty, destinationType);
    }

    public <S1, D1> boolean hasMapperFor(Class<S1> sourceType, Class<D1> destinationType) {
        Projection<S1, D1> projection = new Projection<S1, D1>(sourceType, destinationType);
        return this.mappers.containsKey(projection);
    }

    D map(S source) {
        return this.map(source, null);
    }

    D map(S source, D destination) {
        D destinationObject = destination;
        if (source == null) {
            throw MappingException.denyMappingOfNull();
        }
        if (destination == null) {
            destinationObject = this.createDestination();
        }
        for (Transformation t : this.mappings) {
            t.performTransformation(source, destinationObject);
        }
        return destinationObject;
    }

    private D createDestination() {
        return ReflectionUtil.newInstance(this.destination);
    }

    Class<S> getSource() {
        return this.source;
    }

    Class<D> getDestination() {
        return this.destination;
    }

    Set<Transformation> getMappings() {
        return new HashSet<Transformation>(this.mappings);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean detailed) {
        StringBuilder b = new StringBuilder("Mapping from ").append(detailed ? this.source.getName() : this.source.getSimpleName()).append("\n\t  to ").append(detailed ? this.destination.getName() : this.destination.getSimpleName()).append("\n with transformation:\n");
        MappingConfiguration.transformationToString(this.mappings, detailed, b);
        Set<PropertyDescriptor> unmappedProperties = this.getUnmappedProperties();
        if (unmappedProperties.isEmpty()) {
            b.append("All properties are mapped!");
        } else {
            b.append(Properties.createUnmappedMessage(unmappedProperties));
        }
        return b.toString();
    }

    static void transformationToString(Collection<Transformation> transformations, boolean detailed, StringBuilder b) {
        transformations.stream().sorted(Comparator.comparing(t -> t.getClass().getName())).forEach(t -> b.append("- ").append(t.toString(detailed)).append("\n"));
    }

    protected Map<Projection<?, ?>, InternalMapper<?, ?>> getMappers() {
        return new Hashtable(this.mappers);
    }

    public boolean isWriteNull() {
        return this.writeNullIfSourceIsNull;
    }
}

