/*
 * Decompiled with CFR 0.152.
 */
package com.remondis.remap;

import com.remondis.remap.Lang;
import com.remondis.remap.MappingConfiguration;
import com.remondis.remap.MappingException;
import java.lang.reflect.Constructor;

public final class Types<S> {
    private Class<S> source;

    Types(Class<S> source) {
        Lang.denyNull("source", source);
        this.source = source;
    }

    private void denyNoDefaultConstructor(Class<?> type) {
        try {
            Constructor<?> constructor = type.getConstructor(new Class[0]);
            if (constructor == null) {
                throw MappingException.noDefaultConstructor(type);
            }
        }
        catch (Exception e) {
            throw MappingException.noDefaultConstructor(type, e);
        }
    }

    public <D> MappingConfiguration<S, D> to(Class<D> destination) {
        Lang.denyNull("destination", destination);
        this.denyNoDefaultConstructor(destination);
        return new MappingConfiguration<S, D>(this.source, destination);
    }

    public <D> MappingConfiguration<S, D> to(D destinationInstance) {
        Lang.denyNull("destination", destinationInstance);
        this.denyNoDefaultConstructor(destinationInstance.getClass());
        return new MappingConfiguration(this.source, destinationInstance.getClass());
    }
}

